<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateStockTransferenceGroupsTable extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'stock_transference_groups';

    /**
     * Run the migrations.
     * @table stock_transference_groups
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->dateTime('validated_at')->nullable();
            $table->unsignedInteger('users_id');

            $table->index(["users_id"], 'fk_stock_transference_groups_users1_idx');
            $table->softDeletes();
            $table->timestamps();


            $table->foreign('users_id', 'fk_stock_transference_groups_users1_idx')
                ->references('id')->on('users')
                ->onDelete('cascade')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
     public function down()
     {
       Schema::dropIfExists($this->tableName);
     }
}
