<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateStockTransferencesTable extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'stock_transferences';

    /**
     * Run the migrations.
     * @table stock_transferences
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->dateTime('validated_at')->nullable();
            $table->unsignedInteger('stock_transference_groups_id');
            $table->unsignedInteger('stock_moves_from');
            $table->unsignedInteger('stock_moves_to');

            $table->index(["stock_moves_to"], 'fk_stock_transferences_stock_moves2_idx');

            $table->index(["stock_moves_from"], 'fk_stock_transferences_stock_moves1_idx');

            $table->index(["stock_transference_groups_id"], 'fk_stock_transferences_stock_transference_groups1_idx');
            $table->softDeletes();
            $table->timestamps();


            $table->foreign('stock_transference_groups_id', 'fk_stock_transferences_stock_transference_groups1_idx')
                ->references('id')->on('stock_transference_groups')
                ->onDelete('cascade')
                ->onUpdate('no action');

            $table->foreign('stock_moves_from', 'fk_stock_transferences_stock_moves1_idx')
                ->references('id')->on('stock_moves')
                ->onDelete('cascade')
                ->onUpdate('no action');

            $table->foreign('stock_moves_to', 'fk_stock_transferences_stock_moves2_idx')
                ->references('id')->on('stock_moves')
                ->onDelete('cascade')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
     public function down()
     {
       Schema::dropIfExists($this->tableName);
     }
}
