<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class RemoveRequiredInvoiceIdOnCreditNote extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'credit_notes';

    /**
     * Run the migrations.
     * @table credit_notes
     *
     * @return void
     */
    public function up()
    {
        Schema::table($this->tableName, function (Blueprint $table) {
            $table->unsignedInteger('invoices_id')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table($this->tableName, function (Blueprint $table) {
            $table->unsignedInteger('invoices_id');
        });
    }
}
