<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProviderOperationsTable extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'provider_operations';

    /**
     * Run the migrations.
     * @table provider_operations
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->dateTime('anuled_at')->nullable();
            $table->dateTime('validated_at')->nullable();
            $table->unsignedInteger('providers_id');

            $table->index(["providers_id"], 'fk_provider_operations_providers1_idx');
            $table->softDeletes();
            $table->timestamps();


            $table->foreign('providers_id', 'fk_provider_operations_providers1_idx')
                ->references('id')->on('providers')
                ->onDelete('cascade')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
     public function down()
     {
       Schema::dropIfExists($this->tableName);
     }
}
