<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateExpensesTable extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'expenses';

    /**
     * Run the migrations.
     * @table expenses
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->decimal('amount', 10, 2)->nullable();
            $table->string('reference')->nullable();
            $table->string('description')->nullable();
            $table->dateTime('anuled_at')->nullable();
            $table->dateTime('validated_at')->nullable();
            $table->unsignedInteger('provider_operations_id')->nullable();

            $table->index(["provider_operations_id"], 'fk_expenses_provider_operations1_idx');
            $table->softDeletes();
            $table->timestamps();


            $table->foreign('provider_operations_id', 'fk_expenses_provider_operations1_idx')
                ->references('id')->on('provider_operations')
                ->onDelete('cascade')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
     public function down()
     {
       Schema::dropIfExists($this->tableName);
     }
}
