<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateExpensesAttachmentsTable extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'expenses_attachments';

    /**
     * Run the migrations.
     * @table expenses_attachments
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->text('url')->nullable();
            $table->unsignedInteger('expenses_id');

            $table->index(["expenses_id"], 'fk_expenses_attachments_expenses1_idx');
            $table->softDeletes();
            $table->timestamps();


            $table->foreign('expenses_id', 'fk_expenses_attachments_expenses1_idx')
                ->references('id')->on('expenses')
                ->onDelete('cascade')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
     public function down()
     {
       Schema::dropIfExists($this->tableName);
     }
}
