<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdatePurchaseTable extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'purchases';

    /**
     * Run the migrations.
     * @table purchases
     *
     * @return void
     */
    public function up()
    {
        Schema::table($this->tableName, function (Blueprint $table) {

            $table->dropForeign('fk_purchases_providers1_idx');
            $table->dropIndex('fk_purchases_providers1_idx');
            $table->dropColumn('providers_id');

            $table->unsignedInteger('provider_operations_id')->nullable();
            $table->index(["provider_operations_id"], 'fk_purchases_provider_operations1_idx');
            $table->foreign('provider_operations_id', 'fk_purchases_provider_operations1_idx')
                ->references('id')->on('provider_operations')
                ->onDelete('cascade')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists($this->tableName);
    }
}
