<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdatePurchasePaymentTable extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'purchase_payments';

    /**
     * Run the migrations.
     * @table purchase_payments
     *
     * @return void
     */
    public function up()
    {
        Schema::table($this->tableName, function (Blueprint $table) {
            $table->unsignedInteger('purchases_id')
                ->nullable()->change();

            $table->unsignedInteger('expenses_id')->nullable();
            $table->index(["expenses_id"], 'fk_purchase_payments_expenses1_idx');
            $table->foreign('expenses_id', 'fk_purchase_payments_expenses1_idx')
                ->references('id')->on('expenses')
                ->onDelete('cascade')
                ->onUpdate('no action');


            $table->unsignedInteger('provider_operations_id')->nullable();
            $table->index(["provider_operations_id"], 'fk_purchase_payments_provider_operations1_idx');
            $table->foreign('provider_operations_id', 'fk_purchase_payments_provider_operations1_idx')
                ->references('id')->on('provider_operations')
                ->onDelete('cascade')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists($this->tableName);
    }
}
