<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddSellingWarehouseToInvoiceItems extends Migration
{
     /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'invoice_items';

    /**
     * Run the migrations.
     * @table invoice_items
     *
     * @return void
     */
    public function up()
    {
        Schema::table($this->tableName, function (Blueprint $table) {
            $table->unsignedInteger('warehouses_id')->nullable()->comment('When its null, the system will assume the default saling Warehouse.');
            $table->index(["warehouses_id"], 'fk_invoice_items_warehouses1_idx');
            $table->foreign('warehouses_id', 'fk_invoice_items_warehouses1_idx')
                ->references('id')->on('warehouses')
                ->onDelete('cascade')
                ->onUpdate('no action');
        });
    }


    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('invoice_items', function (Blueprint $table) {
            //
        });
    }
}
