<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDeliveryNotesItemsTable extends Migration
{
    /**
     * Schema table name to migrate
     * @var string
     */
    public $tableName = 'delivery_notes_items';

    /**
     * Run the migrations.
     * @table delivery_notes_items
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger('delivery_notes_id');
            $table->unsignedInteger('saleable_id')->nullable();
            $table->unsignedInteger('warehouses_id')->nullable();
            $table->string('sale_code')->nullable();
            $table->string('sale_name')->nullable();
            $table->decimal('quantity', 8, 2)->nullable();
            $table->decimal('unit_amount', 10, 2)->nullable();
            $table->decimal('discount', 8, 2)->nullable();
            $table->decimal('total_amount', 10, 2)->nullable();
            $table->decimal('vat_tax', 5, 2)->nullable();

            $table->index(["delivery_notes_id"], 'fk_delivery_notes_items_delivery_notes1_idx');

            $table->index(["saleable_id"], 'fk_delivery_notes_items_saleable1_idx');

            $table->index(["warehouses_id"], 'fk_delivery_notes_items_warehouses1_idx');
            $table->softDeletes();
            $table->timestamps();


            $table->foreign('delivery_notes_id', 'fk_delivery_notes_items_delivery_notes1_idx')
                ->references('id')->on('delivery_notes')
                ->onDelete('cascade')
                ->onUpdate('no action');

            $table->foreign('saleable_id', 'fk_delivery_notes_items_saleable1_idx')
                ->references('id')->on('saleable')
                ->onDelete('cascade')
                ->onUpdate('no action');

            $table->foreign('warehouses_id', 'fk_delivery_notes_items_warehouses1_idx')
                ->references('id')->on('warehouses')
                ->onDelete('cascade')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists($this->tableName);
    }
}
