<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInvoicesbydeliveryTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('invoicesbydelivery', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->string('code')->nullable();
            $table->unsignedInteger('shifts_id');
            $table->unsignedInteger('customer_operations_id')->nullable();
            $table->integer('print_nr')->nullable();
            $table->string('document_sequence')->nullable()->default('-1');
            $table->decimal('financial_discount', 8, 2)->nullable();
            $table->string('customer_name')->nullable();
            $table->string('customer_nuit')->nullable();
            $table->string('customer_address')->nullable();
            $table->dateTime('validated_at')->nullable();
            $table->dateTime('anuled_at')->nullable();
            $table->dateTime('due_date')->nullable();
            $table->longText('obs')->nullable();

            $table->index(["customer_operations_id"], 'fk_invoicesbydelivery_customer_operations1_idx');

            $table->index(["shifts_id"], 'fk_invoicesbydelivery_shifts1_idx');
            $table->softDeletes();
            $table->timestamps();



            $table->foreign('shifts_id', 'fk_invoicesbydelivery_shifts1_idx')
                ->references('id')->on('shifts')
                ->onDelete('cascade')
                ->onUpdate('no action');

            $table->foreign('customer_operations_id', 'fk_invoicesbydelivery_customer_operations1_idx')
                ->references('id')->on('customer_operations')
                ->onDelete('set null')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('invoicesbydelivery');
    }
}
