<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInvoicesbydeliveryItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('invoicesbydelivery_items', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger('invoicesbydelivery_id');
            $table->unsignedInteger('saleable_id')->nullable();
            $table->string('sale_code')->nullable();
            $table->string('sale_name')->nullable();
            $table->decimal('quantity', 8, 2)->nullable();
            $table->decimal('unit_amount', 10, 2)->nullable();
            $table->decimal('discount', 8, 2)->nullable();
            $table->decimal('total_amount', 10, 2)->nullable();
            $table->decimal('vat_tax', 5, 2)->nullable();

            $table->index(["invoicesbydelivery_id"], 'fk_invoicesbydelivery_items_invoicesbydelivery1_idx');

            $table->index(["saleable_id"], 'fk_invoicesbydelivery_items_saleable1_idx');
            $table->softDeletes();
            $table->timestamps();


            $table->foreign('invoicesbydelivery_id', 'fk_invoicesbydelivery_items_invoices1_idx')
                ->references('id')->on('invoicesbydelivery')
                ->onDelete('cascade')
                ->onUpdate('no action');

            $table->foreign('saleable_id', 'fk_invoicesbydelivery_items_saleable1_idx')
                ->references('id')->on('saleable')
                ->onDelete('set null')
                ->onUpdate('no action');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('invoicesbydelivery_items');
    }
}
