<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInvoiceHasDeliversTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('invoice_has_delivers', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger('invoicesbydelivery_id');
            $table->unsignedInteger('delivery_notes_id');

            $table->index(["invoicesbydelivery_id"], 'fk_invoice_has_delivers_invoicesbydelivery1_idx');

            $table->index(["delivery_notes_id"], 'fk_invoice_has_delivers_delivery_notes1_idx');


            $table->foreign('invoicesbydelivery_id', 'fk_invoice_has_delivers_invoicesbydelivery1_idx')
                ->references('id')->on('invoicesbydelivery')
                ->onDelete('cascade')
                ->onUpdate('no action');

            $table->foreign('delivery_notes_id', 'fk_invoice_has_delivers_delivery_notes1_idx')
                ->references('id')->on('delivery_notes')
                ->onDelete('cascade')
                ->onUpdate('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('invoice_has_delivers');
    }
}
