<?php
namespace Database\Seeders;
use App\models\users\User;
use Illuminate\Database\Seeder;
use App\models\customers\Customer;

class CustomersSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $this->call(DefaultCustomerCompanySeeder::class);

        $user = User::first();
        $company = $user->company;
        factory(Customer::class, 100)->make()->each(function ($item) use ($company) {
            $item->company()->associate($company);
            $item->save();
        });
    }
}
