<?php
namespace Database\Seeders;
use Illuminate\Support\Str;
use App\models\company\Brunch;
use Illuminate\Database\Seeder;
use App\models\customers\Customer;
use Illuminate\Database\Eloquent\Builder;

class DefaultCustomerCompanySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Brunch::whereDoesntHave('customers', function(Builder $builder){
            return $builder->where('default', true);
        })->chunk(3, function($chunk){
            $chunk->each(function($brunch){
                $customer = new Customer();
                $customer->code = getRandomString(5);
                $customer->name = "Cliente Interno";
                $customer->default = true;
                $customer->company()->associate($brunch);
                $customer->save();
            });
        });
    }
}
