<?php
namespace Database\Seeders;
use App\models\company\SystemFuncionality;
use App\models\users\Role;
use Illuminate\Database\Seeder;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */

    public function run()
    {
        $this->basicSaleRoles();
        $this->cashSaleRoles();
        $this->invoiceRoles();
        $this->debitNoteRoles();
        $this->creditNoteRoles();
        $this->receiptRoles();
        $this->proformaRoles();
        $this->userManagementRoles();
        $this->stockManagers();
        $this->manageCustomers();
        $this->manageShifts();
    }

    private function basicSaleRoles()
    {
        $funcionality = SystemFuncionality::basic_sale();

        $role = new Role();
        $role->name = 'Create basic sale';
        $role->slug = 'create_basic_sale';
        $role->funcionality()->associate($funcionality);
        $role->save();

        $role = new Role();
        $role->name = 'Show basic sale';
        $role->slug = 'show_basic_sale';
        $role->funcionality()->associate($funcionality);
        $role->save();

        $role = new Role();
        $role->name = 'Edit basic sale';
        $role->slug = 'edit_basic_sale';
        $role->funcionality()->associate($funcionality);
        $role->save();
    }

    private function cashSaleRoles()
    {
        $funcionality = SystemFuncionality::cash_sale();

        $role = new Role();
        $role->name = 'Create cash sale';
        $role->slug = 'create_cash_sale';
        $role->funcionality()->associate($funcionality);
        $role->save();

        $role = new Role();
        $role->name = 'Show cash sale';
        $role->slug = 'show_cash_sale';
        $role->funcionality()->associate($funcionality);
        $role->save();

        $role = new Role();
        $role->name = 'Edit cash sale';
        $role->slug = 'edit_cash_sale';
        $role->funcionality()->associate($funcionality);
        $role->save();
    }

    private function invoiceRoles()
    {
        $funcionality = SystemFuncionality::invoice();
        $role = new Role();
        $role->name = 'Create invoice';
        $role->slug = 'create_invoice';
        $role->funcionality()->associate($funcionality);
        $role->save();

        $role = new Role();
        $role->name = 'Show invoice';
        $role->slug = 'show_invoice';
        $role->funcionality()->associate($funcionality);
        $role->save();

        $role = new Role();
        $role->name = 'Edit invoice';
        $role->slug = 'edit_invoice';
        $role->funcionality()->associate($funcionality);
        $role->save();
    }
    private function debitNoteRoles()
    {
        $funcionality = SystemFuncionality::debit_note();

        $role = new Role();
        $role->name = 'Create debit note';
        $role->slug = 'create_debit_note';
        $role->funcionality()->associate($funcionality);
        $role->save();

        $role = new Role();
        $role->name = 'Show debit note';
        $role->slug = 'show_debit_note';
        $role->funcionality()->associate($funcionality);
        $role->save();

        $role = new Role();
        $role->name = 'Edit debit note';
        $role->slug = 'edit_debit_note';
        $role->funcionality()->associate($funcionality);
        $role->save();
    }

    private function creditNoteRoles()
    {
        $funcionality = SystemFuncionality::credit_note();

        $role = new Role();
        $role->name = 'Create credit note';
        $role->slug = 'create_credit_note';
        $role->funcionality()->associate($funcionality);
        $role->save();

        $role = new Role();
        $role->name = 'Show credit note';
        $role->slug = 'show_credit_note';
        $role->funcionality()->associate($funcionality);
        $role->save();

        $role = new Role();
        $role->name = 'Edit credit note';
        $role->slug = 'edit_credit_note';
        $role->funcionality()->associate($funcionality);
        $role->save();
    }


    private function receiptRoles()
    {
        $funcionality = SystemFuncionality::recipt();

        $role = new Role();
        $role->name = 'Create receipt';
        $role->slug = 'create_receipt';
        $role->funcionality()->associate($funcionality);
        $role->save();

        $role = new Role();
        $role->name = 'Show receipt';
        $role->slug = 'show_receipt';
        $role->funcionality()->associate($funcionality);
        $role->save();

        $role = new Role();
        $role->name = 'Edit receipt';
        $role->slug = 'edit_receipt';
        $role->funcionality()->associate($funcionality);
        $role->save();
    }
    private function proformaRoles()
    {
        $funcionality = SystemFuncionality::proforma();

        $role = new Role();
        $role->name = 'Create Proforma';
        $role->slug = 'create_proforma';
        $role->funcionality()->associate($funcionality);
        $role->save();

        $role = new Role();
        $role->name = 'Show Proforma';
        $role->slug = 'show_proforma';
        $role->funcionality()->associate($funcionality);
        $role->save();

        $role = new Role();
        $role->name = 'Edit Proforma';
        $role->slug = 'edit_proforma';
        $role->funcionality()->associate($funcionality);
        $role->save();
    }

    private function userManagementRoles()
    {
        $funcionality = SystemFuncionality::global_manager();
        $role = new Role();
        $role->name = 'Global Admin';
        $role->slug = 'global_admin';
        $role->funcionality()->associate($funcionality);
        $role->save();

        $funcionality = SystemFuncionality::generic();
        $role = new Role();
        $role->name = 'Local Admin';
        $role->slug = 'local_admin';
        $role->funcionality()->associate($funcionality);
        $role->save();
    }

    private function stockManagers()
    {
        $funcionality = SystemFuncionality::generic();
        $role = new Role();
        $role->name = 'Manage Stock';
        $role->slug = 'manage_stocks';
        $role->funcionality()->associate($funcionality);
        $role->save();
    }

    public function manageCompanies()
    {
        $funcionality = SystemFuncionality::global_manager();

        $role = new Role();
        $role->name = 'Create brunch Companies';
        $role->slug = 'create_brunch_companies';
        $role->funcionality()->associate($funcionality);
        $role->save();

        $role = new Role();
        $role->name = 'Show brunch Companies';
        $role->slug = 'show_brunch_companies';
        $role->funcionality()->associate($funcionality);
        $role->save();

        $role = new Role();
        $role->name = 'Edit brunch Companies';
        $role->slug = 'edit_brunch_companies';
        $role->funcionality()->associate($funcionality);
        $role->save();

        $role = new Role();
        $role->name = 'Manage master company';
        $role->slug = 'manage_master_company';
        $role->funcionality()->associate($funcionality);
        $role->save();
    }

    public function manageCustomers()
    {
        $funcionality = SystemFuncionality::generic();
        $role = new Role();
        $role->name = 'Manage customers';
        $role->slug = 'manage_customers';
        $role->funcionality()->associate($funcionality);
        $role->save();
    }

    public function manageShifts(){
        $funcionality = SystemFuncionality::generic();
        $role = new Role();
        $role->name = 'Manage shifts';
        $role->slug = 'manage_shifts';
        $role->funcionality()->associate($funcionality);
        $role->save();
    }
}
