<?php
namespace Database\Seeders;
use App\models\users\Role;
use App\models\stock\VatScheme;
use Illuminate\Database\Seeder;
use App\models\company\CompanyVatScheme;
use App\models\sales\utils\PaymentMethod;
use App\models\company\SystemFuncionality;

class TranslatePreloadedDataToPortugueseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $this->paymentMethods();
        $this->systemFunctionalities();
        $this->companyVatScheme();
        $this->productVatScheme();
        $this->systemRoles();
    }

    private function systemRoles()
    {
        $role = Role::createBasicSale();
        $role->name = "Criar POS";
        $role->save();
        $role = Role::showBasicSale();
        $role->name = "Visualizar POS";
        $role->save();
        $role = Role::editBasicSale();
        $role->name = "Editar POS";
        $role->save();
        $role = Role::createCashSale();
        $role->name = "Criar venda dinheiro";
        $role->save();
        $role = Role::showCashSale();
        $role->name = "Visualizar Venda dinheiro";
        $role->save();
        $role = Role::editCashSale();
        $role->name = "Editar venda dinheiro";
        $role->save();
        $role = Role::createInvoice();
        $role->name = "Criar fatura";
        $role->save();
        $role = Role::showInvoice();
        $role->name = "Visualizar Fatura";
        $role->save();
        $role = Role::editInvoice();
        $role->name = "Editar fatura";
        $role->save();
        $role = Role::createDebitNote();
        $role->name = "Criar nota de débito";
        $role->save();
        $role = Role::showDebitNote();
        $role->name = "Visualizar nota de débito";
        $role->save();
        $role = Role::editDebitNote();
        $role->name = "Editar nota de débito";
        $role->save();
        $role = Role::createCreditNote();
        $role->name = "Criar nota de crédito";
        $role->save();
        $role = Role::showCreditNote();
        $role->name = "Visualizar nota de crédito";
        $role->save();
        $role = Role::editCreditNote();
        $role->name = "Editar nota de crédito";
        $role->save();
        $role = Role::createReceipt();
        $role->name = "Criar recibo";
        $role->save();
        $role = Role::showReceipt();
        $role->name = "Visualizar recibo";
        $role->save();
        $role = Role::editReceipt();
        $role->name = "Editar recibo";
        $role->save();
        $role = Role::createProforma();
        $role->name = "Criar proforma";
        $role->save();
        $role = Role::showProforma();
        $role->name = "Visualizar proforma";
        $role->save();
        $role = Role::editProforma();
        $role->name = "Editar proforma";
        $role->save();
        $role = Role::manageStock();
        $role->name = "Gestor de estoque";
        $role->save();
        $role = Role::manageCustomers();
        $role->name = "Gestor de clientes";
        $role->save();
        $role = Role::manageGlobal();
        $role->name = "Gestor global";
        $role->save();
        $role = Role::manageLocal();
        $role->name = "Gestor de empresa";
        $role->save();

        $role = Role::manageShifts();
        $role->name = "Gestor de turnos";
        $role->save();
    }

    private function productVatScheme()
    {
        $normal = VatScheme::normal();
        $normal->name = 'Regime Normal';
        $normal->save();

        $simplified = VatScheme::exemption();
        $simplified->name = 'Regime Insention';
        $simplified->save();
    }
    private function companyVatScheme()
    {

        $normal = CompanyVatScheme::scheme17();
        $normal->name = 'Regime Normal';
        $normal->save();


        $simplified = CompanyVatScheme::scheme3();
        $simplified->name = 'Regime Simplificado';
        $simplified->save();
    }

    private function systemFunctionalities()
    {
        $funcionality = SystemFuncionality::global_manager();
        $funcionality->name = 'Gestão Global';
        $funcionality->save();


        $funcionality =  SystemFuncionality::generic();
        $funcionality->name = 'Genéricas';
        $funcionality->save();

        $funcionality =  SystemFuncionality::basic_sale();
        $funcionality->name = 'POS';
        $funcionality->save();


        $funcionality = SystemFuncionality::invoice();
        $funcionality->name = 'Fatura';
        $funcionality->save();

        $funcionality =  SystemFuncionality::recipt();
        $funcionality->name = 'Recibos';
        $funcionality->save();

        $funcionality =  SystemFuncionality::debit_note();
        $funcionality->name = 'Notas de débito';
        $funcionality->save();

        $funcionality = SystemFuncionality::credit_note();
        $funcionality->name = 'Notas de Crédito';
        $funcionality->save();

        $funcionality = SystemFuncionality::cash_sale();
        $funcionality->name = 'Venda dinheiro';
        $funcionality->save();
    }

    private function paymentMethods()
    {
        $bankpos = PaymentMethod::bankpos();
        $bankpos->name = "Terminal POS";
        $bankpos->save();


        $bankcheck = PaymentMethod::bankcheck();
        $bankcheck->name = "Cheque Bancário";
        $bankcheck->save();


        $banktransfer = PaymentMethod::banktransfer();
        $banktransfer->name = "Transferência Bancária";
        $banktransfer->save();


        $money = PaymentMethod::money();
        $money->name = "Numerário";
        $money->save();

        $systemadvance = PaymentMethod::systemadvance();
        $systemadvance->name = "Adiantamento";
        $systemadvance->save();

        $crmpoints = PaymentMethod::crmpoints();

        $crmpoints->name = "Pontuação CRM";
        $crmpoints->save();

        $providerAdvance = PaymentMethod::providerAdvance();
        $providerAdvance->name = "Adiantamento/Fornecedor";
        $providerAdvance->save();
    }
}
