<?php
namespace Database\Seeders;
use App\models\company\SystemFuncionality;
use App\models\users\Role;
use App\models\users\User;
use Illuminate\Database\Seeder;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        factory(User::class, 4)->create();

        $samuel = User::find(1);
        $samuel->name = 'Samuel Bie';
        $samuel->email = 'samuelbie@outlook.com';
        $samuel->save();
        $samuel->roles()->attach(Role::all()->pluck('id'));

        $company = $samuel->company;
        $company->funcionalities()->attach(SystemFuncionality::all()->pluck('id'));

        $demo = User::find(2);
        $demo->name = 'Demo User';
        $demo->email = 'demo@mail.com';
        $demo->save();
        $demo->roles()->attach(Role::all()->pluck('id'));

        if (!$company->is($demo->company)) {
            $company = $demo->company;
            $company->funcionalities()->attach(SystemFuncionality::all()->pluck('id'));
        }

        $izhaar = User::find(3);
        $izhaar->name = 'Izhaar Virani';
        $izhaar->email = 'izhaar.virani@outlook.com';
        $izhaar->save();
        $izhaar->roles()->attach(Role::all()->pluck('id'));

        if (!$company->is($izhaar->company)) {
            $company = $izhaar->company;
            $company->funcionalities()->attach(SystemFuncionality::all()->pluck('id'));
        }


        $armando = User::find(4);
        $armando->name = 'Armando Paulo';
        $armando->email = 'armandopaulo@gmail.com';
        $armando->invisible = 1;
        $armando->save();
        $armando->roles()->attach(Role::all()->pluck('id'));

        if (!$company->is($armando->company)) {
            $company = $armando->company;
            $company->funcionalities()->attach(SystemFuncionality::all()->pluck('id'));
        }
    }
}
