<div class="container-fluid">
    <div class="row">
        <!-- left column -->
        <div class="col-md-12">
            <!-- jquery validation -->
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">@lang('Dados da sucursal')</h3>
                </div>
                <!-- /.card-header -->
                <form role="form" class="m-2" id="create-brunch-company">
                    <div class="row">
                        <div class="form-group col-sm-4">
                            <label for="name">@lang('Nome')</label>
                            <input type="text" name="name" class="form-control" id="name"
                                placeholder="Terminal 004 Lda">
                        </div>

                        <div class="form-group col-sm-4">
                            <label for="nuit">@lang('NUIT')</label>
                            <input type="text" name="nuit" class="form-control" id="nuit" placeholder="125896321">
                        </div>

                        <div class="form-group col-sm-4">
                            <label for="vat_scheme">@lang('Regime de IVA')</label>
                            <select name="vat_scheme" class="form-control select2bs4" style="width: 100%;"
                                data-placeholder="@lang('Seleciona regime da empresa')">
                                @foreach ($vatschemes as $scheme)
                                <option value="{{ $scheme->id }}">{{ $scheme->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-sm-4">
                            <label for="country">@lang('País')</label>
                            <input type="text" name="country" class="form-control" id="country"
                                placeholder="Mozambique">
                        </div>

                        <div class="form-group col-sm-4">
                            <label for="city">@lang('Cidade')</label>
                            <input type="text" name="city" class="form-control" id="city" placeholder="Mozambique">
                        </div>

                        <div class="form-group col-sm-4">
                            <label for="address">@lang('Endereço')</label>
                            <input type="text" name="address" class="form-control" id="address"
                                placeholder="Av.24 de Julho #105">
                        </div>

                        <div class="form-group col-sm-6">
                            <label for="phone">@lang('Telefone')</label>
                            <input type="text" name="phone" class="form-control" id="phone" placeholder="823847556">
                        </div>

                        <div class="form-group col-sm-6">
                            <label for="email">@lang('Email')</label>
                            <input type="email" name="email" class="form-control" id="email"
                                placeholder="exemplo@mail.com">
                        </div>






                        <div class="form-group col-sm-12">
                            <label for="gender">@lang('Funcionalidades')</label>
                            <select class="select2bs4" name="funcionalities[]" multiple="multiple"
                                data-placeholder="@lang('Selecione as funcionalidades da sucursal')"
                                style="width: 100%;">
                                @foreach ($funcionalities as $role)
                                <option value="{{ $role->id }}"> {{ $role->name }} </option>
                                @endforeach
                            </select>
                        </div>


                    </div>



                    <div class="row">
                        <div class="form-group col-12">
                            <!-- /.card-body -->
                            <button type="submit" class="btn btn-sm btn-outline-primary save">@lang('Salvar')</button>
                            <button type="button"
                                class="btn btn-sm btn-outline-success d-none saved">@lang('Salvo')</button>
                            <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                                    class="fa fa-spinner fa-spin fa-circle-notch"
                                    aria-hidden="true"></i>@lang('Salvando')</button>
                            <button type="button"
                                class="btn btn-sm btn-outline-danger d-none error">@lang('Erro')</button>
                        </div>
                    </div>
                </form>

            </div>
            <!-- /.card -->
        </div>
        <!--/.col (left) -->
    </div>
    <!-- /.row -->
</div>


@section('plugins.JqueryValidation', true)
@section('plugins.Select2', true)
@section('plugins.Sweetalert2', true)
@push('js')
<script type="text/javascript">
    $(document).ready(function () {
      $.validator.setDefaults({
        submitHandler: saveCompanyData
      });
      $('#create-brunch-company').validate({
        rules: {
            name:{
                required:true,
                minlength:2
            },
            nuit:{
                required:true,
                minlength:9,
                maxlength:9
            },
            country:{
                required:true,
                minlength:2
            },
            city:{
                required:true,
                minlength:2
            },
            email:{
                required:true,
                email: true,
            },
            phone:{
                required:true,
                minlength:2
            },
            address:{
                required:true,
                minlength:2
            },
        },
        messages: {
            name:{
                required:'Por favor introduza o nome da sucursal',
                minlength:'O nome deve ter no mínimo 2 caracteres'
            },
            nuit:{
                required:'Por favor introduza o NUIT da sucursal',
                minlength:'O NUIT deve ter no mínimo 9 caracteres',
                maxlength:'O NUIT deve ter no máximo 9 caracteres',
            },
            country:{
                required:'Por favor introduza o País da sucursal',
                minlength:'O nome deve ter no mínimo 2 caracteres'
            },
            city:{
                required:'Por favor introduza o País da sucursal',
                minlength:'O nome do país deve ter no mínimo 2 caracteres'
            },
            email:{
                required:'Por favor introduza o email da sucursal',
                email:'Email introduzido é invalido',
            },
            phone:{
                required:'Por favor introduza o telefone da sucursal',
            },
            address:{
                required:'Por favor introduza o endereço da sucursal',
            },
        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
          error.addClass('invalid-feedback');
          element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
          $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
          $(element).removeClass('is-invalid');
        }
      });
    });

    $(document).ready(function () {
        $('.select2bs4').select2({
            theme: 'bootstrap4'
        })
    });


    function saveCompanyData(){
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
      });


        let data = $('form#create-brunch-company').serializeArray();

        $.ajax({
            ...ajaxSettings,
            method:'POST',
            url: "{{ URL::signedRoute('api.company.brunch.store') }}",
            data: data,
            beforeSend: function(){
              $('form#create-brunch-company button.save').addClass('d-none');
              $('form#create-brunch-company button.saved').addClass('d-none');
              $('form#create-brunch-company button.error').addClass('d-none');
              $('form#create-brunch-company button.saving').removeClass('d-none');
            },
            statusCode : {
                201: function(response){
                  Toast.fire({
                    type: 'success',
                    title: '@lang("New user has been created").'
                  })

                  $('form#create-brunch-company button.save').addClass('d-none');
                  $('form#create-brunch-company button.saved').removeClass('d-none');
                  $('form#create-brunch-company button.saving').addClass('d-none');
                  $('form#create-brunch-company button.error').addClass('d-none');
                    setTimeout(() => {
                        goto(response.url.web);
                    }, 3000)
                },
                401:(response) =>{

                    Toast.fire({
                        type: 'error',
                        title: '@lang("Volte a fazer o login").'
                    });

                    $.ajax({
                        url: "{{ URL::signedRoute('web.system.exit') }}",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });

                },
                422:(response) =>{
                  Toast.fire({
                    type: 'error',
                    title: '@lang("Verifique os dados inseridos e submeta outra vez").'
                  })
                },
            },
            error: (response) => {
              $('form#create-brunch-company button.save').addClass('d-none');
              $('form#create-brunch-company button.saved').addClass('d-none');
              $('form#create-brunch-company button.saving').addClass('d-none');
              $('form#create-brunch-company button.error').removeClass('d-none');
              setTimeout(() => {
                $('form#create-brunch-company button.save').removeClass('d-none');
                $('form#create-brunch-company button.saved').addClass('d-none');
                $('form#create-brunch-company button.saving').addClass('d-none');
                $('form#create-brunch-company button.error').addClass('d-none');
              }, 2000)
            }
        });
    }
</script>
@endpush
