@section('plugins.Datatables', true)
@section('js')
<script type="text/javascript">
    $(document).ready(function () {
        initDatatable();
    });
</script>
@stop


<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <a href="{{ URL::signedRoute('web.company.brunch.create') }}" class="btn btn-sm btn-outline-primary">@lang('Criar nova')</a>
        </h3>
    </div>
    <!-- /.card-header -->
    <div class="card-body">
        <table id="table" class="sb-datatable table table-bordered table-striped display compact">
            <thead>
                <tr>
                    <th>@lang('Nome')</th>
                    <th>@lang('Pais')</th>
                    <th>@lang('Cidade')</th>
                    <th>@lang('Telefone')</th>
                    <th>@lang('Regime de IVA')</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($companies as $brunch)
                <tr ondblclick="goto('{{ URL::signedRoute('web.company.brunch.show', ['brunch'=>$brunch->id]) }}')" class="cursor-pointer">
                    <td>{{ $brunch->name }}</td>
                    <td>{{ $brunch->country }}</td>
                    <td>{{ $brunch->city }}</td>
                    <td>{{ $brunch->phone }}</td>
                    <td>{{ $brunch->vatScheme->name   }}</td>
                </tr>
                @endforeach

            </tbody>
            <tfoot>
                <tr>
                    <th>@lang('Nome')</th>
                    <th>@lang('Pais')</th>
                    <th>@lang('Cidade')</th>
                    <th>@lang('Telefone')</th>
                    <th>@lang('Regime de IVA')</th>
                </tr>
            </tfoot>
        </table>
    </div>
    <!-- /.card-body -->
</div>