<form role="form" class="m-2" id="crm-config">
    <div class="row">
        <div class="form-group col-sm-4">
            <label for="enable">@lang('Ativar uso de CRM')</label>
            <br>
            <input type="checkbox" class="bootstrap-switch form-control" name="enable" @if($crm_config)
                @if($crm_config->isEnabled())
            checked="true"
            @endif @endif
            data-bootstrap-switch
            data-off-color="danger" data-on-color="success">
        </div>

        <div class="form-group col-sm-4">
            <label for="increment_amount">@lang('Montante de incremento')</label>
            <input type="text" name="increment_amount" class="form-control" id="increment_amount" placeholder="1000"
                @if($crm_config) value="{{ $crm_config->increment_amount }}" @endif>

        </div>

        <div class="form-group col-sm-4">
            <label for="point_amount">@lang('Valor de conversão de pontos')</label>
            <input type="text" name="point_amount" class="form-control" id="point_amount" placeholder="10"
                @if($crm_config) value="{{ $crm_config->point_amount }}" @endif>
        </div>
    </div>

    <div class="row">
        <div class="form-group col-12">
            <!-- /.card-body -->
            <button type="submit" class="btn btn-sm btn-outline-primary save">@lang('Salvar')</button>
            <button type="button" class="btn btn-sm btn-outline-success d-none saved">@lang('Salvo')</button>
            <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                    class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i>@lang('Salvando')</button>
            <button type="button" class="btn btn-sm btn-outline-danger d-none error">@lang('Erro')</button>
        </div>
    </div>
</form>


@push('js')
<script type="text/javascript">
    $(document).ready(function () {
      $.validator.setDefaults({
        submitHandler: saveCRMConfig
      });
      $('#crm-config').validate({
        rules: {
            increment_amount:{
                required:true,
                min:0
            },
            point_amount:{
                required:true,
                min:0
            },
        },
        messages: {
            name:{
                required:'Por favor introduza o nome da sucursal',
                minlength:'O nome deve ter no mínimo 2 caracteres'
            },
            nuit:{
                required:'Por favor introduza o NUIT da sucursal',
                minlength:'O NUIT deve ter no mínimo 9 caracteres',
                maxlength:'O NUIT deve ter no máximo 9 caracteres',
            },
            country:{
                required:'Por favor introduza o País da sucursal',
                minlength:'O nome deve ter no mínimo 2 caracteres'
            },
            city:{
                required:'Por favor introduza o País da sucursal',
                minlength:'O nome do país deve ter no mínimo 2 caracteres'
            },
            email:{
                required:'Por favor introduza o email da sucursal',
                email:'Email introduzido é invalido',
            },
            phone:{
                required:'Por favor introduza o telefone da sucursal',
            },
            address:{
                required:'Por favor introduza o endereço da sucursal',
            },
        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
          error.addClass('invalid-feedback');
          element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
          $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
          $(element).removeClass('is-invalid');
        }
      });
    });

    $(document).ready(function () {
        $('.select2bs4').select2({
            theme: 'bootstrap4'
        })
    });


    function saveCRMConfig(){
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
      });


        let data = $('form#crm-config').serializeArray();

        $.ajax({
            ...ajaxSettings,
            method:'POST',
            url: "{{ URL::signedRoute('api.company.brunch.crm.store', ['brunch'=> $brunch->id]) }}",
            data: data,
            beforeSend: function(){
              $('form#crm-config button.save').addClass('d-none');
              $('form#crm-config button.saved').addClass('d-none');
              $('form#crm-config button.error').addClass('d-none');
              $('form#crm-config button.saving').removeClass('d-none');
            },
            statusCode : {
                202: function(response){
                  Toast.fire({
                    type: 'success',
                    title: '@lang("New user has been created").'
                  })

                  $('form#crm-config button.save').addClass('d-none');
                  $('form#crm-config button.saved').removeClass('d-none');
                  $('form#crm-config button.saving').addClass('d-none');
                  $('form#crm-config button.error').addClass('d-none');
                    setTimeout(() => {
                        $('form#crm-config button.save').removeClass('d-none');
                        $('form#crm-config button.saved').addClass('d-none');
                        $('form#crm-config button.saving').addClass('d-none');
                        $('form#crm-config button.error').addClass('d-none');
                    }, 3000)
                },
                401:(response) =>{

                    Toast.fire({
                        type: 'error',
                        title: '@lang("Volte a fazer o login").'
                    });

                    $.ajax({
                        url: "{{ URL::signedRoute('web.system.exit') }}",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });

                },
                422:(response) =>{
                  Toast.fire({
                    type: 'error',
                    title: '@lang("Verifique os dados inseridos e submeta outra vez").'
                  })
                },
            },
            error: (response) => {
              $('form#crm-config button.save').addClass('d-none');
              $('form#crm-config button.saved').addClass('d-none');
              $('form#crm-config button.saving').addClass('d-none');
              $('form#crm-config button.error').removeClass('d-none');
              setTimeout(() => {
                $('form#crm-config button.save').removeClass('d-none');
                $('form#crm-config button.saved').addClass('d-none');
                $('form#crm-config button.saving').addClass('d-none');
                $('form#crm-config button.error').addClass('d-none');
              }, 2000)
            }
        });
    }
</script>
@endpush
