<form role="form" class="m-2" id="basic-sale-config">

  <div class="row">
    <div class="form-group col-sm-4">
      <label for="sale_type">@lang('Tipo de venda')</label>
      <select name="sale_type" class="form-control select2bs4" style="width: 100%;"
        data-placeholder="@lang('Tipo de venda na area simples')">
        <option value="fast">@lang('Rapido')</option>
        <option value="normal" @if($sale_config) @if (!$sale_config->fast_sale)
          selected
          @endif @endif>@lang('normal')</option>
      </select>
    </div>
  </div>



  <div class="row">
    <div class="form-group col-12">
      <!-- /.card-body -->
      <button type="submit" class="btn btn-sm btn-outline-primary save">@lang('Salvar')</button>
      <button type="button" class="btn btn-sm btn-outline-success d-none saved">@lang('Salvo')</button>
      <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
          class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i>@lang('Salvando')</button>
      <button type="button" class="btn btn-sm btn-outline-danger d-none error">@lang('Erro')</button>
    </div>
  </div>
</form>

@push('js')
<script type="text/javascript">
  $(document).ready(function () {
      $.validator.setDefaults({
        submitHandler: basicsaleconfig
      });
      $('#basic-sale-config').validate({
        rules: {

        },
        messages: {
            name:{
                required:'Por favor introduza o nome da sucursal',
                minlength:'O nome deve ter no mínimo 2 caracteres'
            },
            nuit:{
                required:'Por favor introduza o NUIT da sucursal',
                minlength:'O NUIT deve ter no mínimo 9 caracteres',
                maxlength:'O NUIT deve ter no máximo 9 caracteres',
            },
            country:{
                required:'Por favor introduza o País da sucursal',
                minlength:'O nome deve ter no mínimo 2 caracteres'
            },
            city:{
                required:'Por favor introduza o País da sucursal',
                minlength:'O nome do país deve ter no mínimo 2 caracteres'
            },
            email:{
                required:'Por favor introduza o email da sucursal',
                email:'Email introduzido é invalido',
            },
            phone:{
                required:'Por favor introduza o telefone da sucursal',
            },
            address:{
                required:'Por favor introduza o endereço da sucursal',
            },
        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
          error.addClass('invalid-feedback');
          element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
          $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
          $(element).removeClass('is-invalid');
        }
      });
    });

    $(document).ready(function () {
        $('.select2bs4').select2({
            theme: 'bootstrap4'
        })
    });


    function basicsaleconfig(){
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
      });


        let data = $('form#basic-sale-config').serializeArray();


        $.ajax({
            ...ajaxSettings,
            method:'POST',
            url: "{{ URL::signedRoute('api.company.brunch.configuration.store', ['brunch'=> $brunch->id]) }}",
            data: data,
            beforeSend: function(){
              $('form#basic-sale-config button.save').addClass('d-none');
              $('form#basic-sale-config button.saved').addClass('d-none');
              $('form#basic-sale-config button.error').addClass('d-none');
              $('form#basic-sale-config button.saving').removeClass('d-none');
            },
            statusCode : {
                201: function(response){
                  Toast.fire({
                    type: 'success',
                    title: '@lang("New user has been created").'
                  })

                  $('form#basic-sale-config button.save').addClass('d-none');
                  $('form#basic-sale-config button.saved').removeClass('d-none');
                  $('form#basic-sale-config button.saving').addClass('d-none');
                  $('form#basic-sale-config button.error').addClass('d-none');
                    setTimeout(() => {
                        $('form#basic-sale-config button.save').removeClass('d-none');
                $('form#basic-sale-config button.saved').addClass('d-none');
                $('form#basic-sale-config button.saving').addClass('d-none');
                $('form#basic-sale-config button.error').addClass('d-none');
                    }, 3000)
                },
                401:(response) =>{

                    Toast.fire({
                        type: 'error',
                        title: '@lang("Volte a fazer o login").'
                    });

                    $.ajax({
                        url: "{{ URL::signedRoute('web.system.exit') }}",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });

                },
                422:(response) =>{
                  Toast.fire({
                    type: 'error',
                    title: '@lang("Verifique os dados inseridos e submeta outra vez").'
                  })
                },
            },
            error: (response) => {
              $('form#basic-sale-config button.save').addClass('d-none');
              $('form#basic-sale-config button.saved').addClass('d-none');
              $('form#basic-sale-config button.saving').addClass('d-none');
              $('form#basic-sale-config button.error').removeClass('d-none');
              setTimeout(() => {
                $('form#basic-sale-config button.save').removeClass('d-none');
                $('form#basic-sale-config button.saved').addClass('d-none');
                $('form#basic-sale-config button.saving').addClass('d-none');
                $('form#basic-sale-config button.error').addClass('d-none');
              }, 2000)
            }
        });
    }
</script>
@endpush
