@section('plugins.Datatables', true)
@push('js')
<script type="text/javascript">
    $(document).ready(function () {
        initDatatable();
    });
</script>
@endpush


<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <a href="{{ URL::signedRoute('web.customer.create') }}" class="btn btn-sm btn-outline-primary">@lang('Criar
                novo')</a>
        </h3>
    </div>
    <!-- /.card-header -->
    <div class="card-body">
        <table id="table" class="sb-datatable table table-bordered table-striped display compact">
            <thead>
                <tr>
                    <th>@lang('Nome')</th>
                    <th>@lang('Codigo')</th>
                    <th>@lang('Telefone')</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($customers as $customer)
                <tr ondblclick="goto('{{ URL::signedRoute('web.customer.show', ['customer'=>$customer->id]) }}')"
                    class="cursor-pointer">
                    <td>{{ $customer->name }}</td>
                    <td>{{ $customer->code }}</td>
                    <td>{{ $customer->phone }}</td>
                </tr>
                @endforeach

            </tbody>
            <tfoot>
                <tr>
                    <th>@lang('Nome')</th>
                    <th>@lang('Codigo')</th>
                    <th>@lang('Telefone')</th>
                </tr>
            </tfoot>
        </table>
    </div>
    <!-- /.card-body -->
</div>