@extends('layouts.app')
@section('title', $customer->name)

@section('content_header')
<div class="container-fluid">
    <div class="row mb-2">
        <div class="col-sm-6">
            <h1>{{ $customer->name }}</h1>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="{{ URL::signedRoute('web.system.home') }}">@lang('Home')</a></li>
                <li class="breadcrumb-item"><a href="{{ URL::signedRoute('web.customer.index') }}">@lang('Cliente')</a></li>
                <li class="breadcrumb-item active">{{ $customer->code }}</li>
            </ol>
        </div>
    </div>
</div>
@stop


@section('content')
@include('customers.customer.show.parts.tabs')
@endsection



@section('plugins.JqueryValidation', true)
@section('plugins.Sweetalert2', true)