
  <form role="form" class="" id="delete-customers">
  <div class="row">
    <div class="col-12">

      <a name="" id="" class="btn btn-sm btn-outline-primary"
        href="{{ URL::route('web.customer.statement', ['customer'=> $customer->id]) }}" role="button">@lang('Extrato')
      </a>

@can('manage-local')
      <button type="submit" class="btn btn-sm btn-outline-danger save">@lang('Apagar')</button>
@endcan

      <button type="button" class="btn btn-sm btn-outline-success d-none saved">@lang('Apagado')</button>
      <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
          class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i>@lang('Apagando')</button>
      <button type="button" class="btn btn-sm btn-outline-danger d-none error">@lang('Erro')</button>
    </div>
  </div>
</form>








@push('js')
<script type="text/javascript">
  $(document).ready(function () {
      $.validator.setDefaults({
        submitHandler: deleteSaleable
      });

      $('#delete-customers').validate({
        rules: {

        },
        messages: {

        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
          error.addClass('invalid-feedback');
          element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
          $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
          $(element).removeClass('is-invalid');
        }
      });
    });

    function deleteSaleable(){
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
      });


        let data = $('form#delete-customers').serializeArray();

        $.ajax({
            ...ajaxSettings,
            method:'DELETE',
            url: "{{ URL::signedRoute('api.customer.destroy', ['customer'=>$customer->id]) }}",
            data: data,
            beforeSend: function(){
              $('form#delete-customers button.save').addClass('d-none');
              $('form#delete-customers button.saved').addClass('d-none');
              $('form#delete-customers button.error').addClass('d-none');
              $('form#delete-customers button.saving').removeClass('d-none');
            },
            statusCode : {
                204: function(response){
                  Toast.fire({
                    type: 'success',
                    title: '@lang("Product has been edited").'
                  })

                  $('form#delete-customers button.save').addClass('d-none');
                  $('form#delete-customers button.saved').removeClass('d-none');
                  $('form#delete-customers button.saving').addClass('d-none');
                  $('form#delete-customers button.error').addClass('d-none');
                    setTimeout(() => {
                        goto("{{ URL::signedRoute('web.customer.index') }}");
                    }, 3000)
                },
                401:(response) =>{

                    Toast.fire({
                        type: 'error',
                        title: '@lang("Volte a fazer o login").'
                    })

                    $.ajax({
                        url: "{{ URL::signedRoute('web.system.exit') }}",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });
                },
                422:(response) =>{
                  Toast.fire({
                    type: 'error',
                    title: '@lang("Verifique os dados inseridos e submeta outra vez").'
                  })
                },
            },
            error: (response) => {
              $('form#delete-customers button.save').addClass('d-none');
              $('form#delete-customers button.saved').addClass('d-none');
              $('form#delete-customers button.saving').addClass('d-none');
              $('form#delete-customers button.error').removeClass('d-none');
              setTimeout(() => {
                $('form#delete-customers button.save').removeClass('d-none');
                $('form#delete-customers button.saved').addClass('d-none');
                $('form#delete-customers button.saving').addClass('d-none');
                $('form#delete-customers button.error').addClass('d-none');
              }, 2000)
            }
        });
    }
</script>
@endpush
