<div class="row">
    <div class="col-sm-6">
        <dl class="row">
            <dt class="col-sm-4">@lang('Nome')</dt>
            <dd class="col-sm-8">{{ $customer->name }}</dd>

            <dt class="col-sm-4">@lang('Codigo')</dt>
            <dd class="col-sm-8">{{ $customer->code }}</dd>

            <dt class="col-sm-4">@lang('NUIT')</dt>
            <dd class="col-sm-8">{{ $customer->nuit }}</dd>

            <dt class="col-sm-4">@lang('Telefone')</dt>
            <dd class="col-sm-8">{{ $customer->phone }}</dd>

            <dt class="col-sm-4">@lang('Endereço')</dt>
            <dd class="col-sm-8">{{ $customer->address }}</dd>


            <dt class="col-sm-4">@lang('Desconto')</dt>
            <dd class="col-sm-8">{{ number_format($customer->discount, 2) }} %</dd>

            <dt class="col-sm-4">@lang('Saldo corrente')</dt>
            <dd class="col-sm-8">{{ number_format($customer->balance(), 2) }}</dd>

            <dt class="col-sm-4">@lang('Pontos CRM')</dt>
            @php
            $points = $customer->unusedCustomerPoints()->sum('points');
            $amount = $customer->unusedCustomerAmount();
            @endphp

            <dd class="col-sm-8">{{ number_format($points, 2) }} ({{ $amount }} MT)</dd>
        </dl>
    </div>

    <div class="col-sm-6">
        <div class="row">
            <div class="col-sm-12">
                <img src="data:image/png;base64,{{ DNS1D::getBarcodePNG($customer->code, 'C39', 1,60) }}" alt="barcode"   />
            </div>

            <div class="col-sm-12 pt-2">
                <img src="data:image/png;base64,{{ DNS2D::getBarcodePNG($customer->code, 'QRCODE', 8,8) }}" alt="qrcode"   />
            </div>
        </div>
    </div>
</div>

@include('customers.customer.show.parts.mini.delete')
