<form role="form" id="edit-customer">
    <div class="row">
        <div class="form-group col-sm-6">
            <label for="name">@lang('Nome')</label>
            <input type="text" name="name" class="form-control" id="name" value="{{ $customer->name }}" placeholder="Januario Bambo">
        </div>

        <div class="form-group col-sm-3">
            <label for="nuit">@lang('NUIT')</label>
            <input type="text" name="nuit" class="form-control" id="nuit" value="{{ $customer->nuit }}" placeholder="125896321">
        </div>

        <div class="form-group col-sm-3">
            <label for="phone">@lang('Telefone')</label>
            <input type="text" name="phone" class="form-control" id="phone" value="{{ $customer->phone }}" placeholder="823847556">
        </div>

        <div class="form-group col-sm-8">
            <label for="address">@lang('Endereço')</label>
            <input type="text" name="address" class="form-control" id="address" value="{{ $customer->address }}" placeholder="Av Jullius Nherere">
        </div>

        <div class="form-group col-sm-4">
            <label for="discount">@lang('Desconto')</label>
            <input type="text" name="discount" class="form-control" id="discount" value="{{ $customer->discount }}" placeholder="10">
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <button type="submit" class="btn btn-sm btn-outline-primary save">@lang('Salvar')</button>
            <button type="button" class="btn btn-sm btn-outline-success d-none saved">@lang('Salvo')</button>
            <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                    class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i>@lang('Salvando')</button>
            <button type="button" class="btn btn-sm btn-outline-danger d-none error">@lang('Erro')</button>
        </div>
    </div>
</form>



@push('js')
<script type="text/javascript">
    $(document).ready(function () {
      $.validator.setDefaults({
        submitHandler: saveCompanyData
      });

      $('#edit-customer').validate({
        rules: {
            name:{
                required:true,
                minlength:2
            },
        },
        messages: {
            name:{
              required:'Por favor introduza o nome do cliente',
              minlength:'O nome deve ter no mínimo 2 caracteres'
            },
        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
          error.addClass('invalid-feedback');
          element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
          $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
          $(element).removeClass('is-invalid');
        }
      });
    });
    function saveCompanyData(){
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
      });


        let data = $('form#edit-customer').serializeArray();

        $.ajax({
            ...ajaxSettings,
            method:'PUT',
            url: "{{ URL::signedRoute('api.customer.update', ['customer' => $customer->id]) }}",
            data: data,
            beforeSend: function(){
              $('form#edit-customer button.save').addClass('d-none');
              $('form#edit-customer button.saved').addClass('d-none');
              $('form#edit-customer button.error').addClass('d-none');
              $('form#edit-customer button.saving').removeClass('d-none');
            },
            statusCode : {
                202: function(response){
                  Toast.fire({
                    type: 'success',
                    title: '@lang("Product has been created").'
                  })

                  $('form#edit-customer button.save').addClass('d-none');
                  $('form#edit-customer button.saved').removeClass('d-none');
                  $('form#edit-customer button.saving').addClass('d-none');
                  $('form#edit-customer button.error').addClass('d-none');
                    setTimeout(() => {
                        goto(response.url.web);
                    }, 3000)
                },
                401:(response) =>{

                    Toast.fire({
                        type: 'error',
                        title: '@lang("Volte a fazer o login").'
                    })

                    $.ajax({
                        url: "{{ URL::signedRoute('web.system.exit') }}",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });
                },
                422:(response) =>{
                  Toast.fire({
                    type: 'error',
                    title: '@lang("Verifique os dados inseridos e submeta outra vez").'
                  })
                },
            },
            error: (response) => {
              $('form#edit-customer button.save').addClass('d-none');
              $('form#edit-customer button.saved').addClass('d-none');
              $('form#edit-customer button.saving').addClass('d-none');
              $('form#edit-customer button.error').removeClass('d-none');
              setTimeout(() => {
                $('form#edit-customer button.save').removeClass('d-none');
                $('form#edit-customer button.saved').addClass('d-none');
                $('form#edit-customer button.saving').addClass('d-none');
                $('form#edit-customer button.error').addClass('d-none');
              }, 2000)
            }
        });
    }
</script>
@endpush
