@extends('layouts.app')
@section('title', __('Extrato') .' '. $customer->name )

@section('content_header')
<div class="container-fluid">
    <div class="row mb-2">
        <div class="col-sm-6">
            <h1>{{ $customer->name }}</h1>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="{{ URL::signedRoute('web.system.home') }}">@lang('Home')</a></li>
                <li class="breadcrumb-item"><a href="{{ URL::signedRoute('web.customer.index') }}">@lang('Cliente')</a>
                </li>
                <li class="breadcrumb-item"><a
                        href="{{ URL::signedRoute('web.customer.show', ['customer' =>  $customer->id]) }}">@lang('Detalhes')</a>
                </li>
                <li class="breadcrumb-item active">@lang('Extrato')</li>
            </ol>
        </div>
    </div>
</div>
@stop

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-3">
            @include('customers.customer.statement.parts.profile')
        </div>
        <div class="col-md-9">
            <div class="card">
                <div class="card-header p-3">
                    <h3 class="card-title">
                        @lang('Extrato') <span class="reference"></span>
                    </h3>

                    <div class="card-tools">
                        <button type="button" class="btn btn-tool btn-sm daterange" data-toggle="tooltip" title="Date range">
                            <i class="far fa-calendar-alt"></i>
                        </button>
                    </div>
                </div>
                <div>
                    <div class="tab-content">
                        <div class="active tab-pane" id="activity">
                            <div>
                              <livewire:customer.customer-statement :customer='$customer'>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
