@section('plugins.Handlebars', true)
@section('plugins.Datatables', true)
@section('plugins.DatatablesExport', true)
@section('plugins.Datepicker', true)


<script id="table-template" type="text/x-handlebars-template">
    <table class="sb-datatable export excel pdf table table-bordered table-striped display compact">
        <thead>
            <tr>
                <th>@lang('Codigo de Operação')</th>
                <th>@lang('Data')</th>
                <th>@lang('Descrição')</th>
                <th>@lang('Débito')</th>
                <th>@lang('Crédito')</th>
                <th>@lang('Saldo')</th>
            </tr>
        </thead>
        <tbody>
       @{{#each items }}
            <tr onclick="goto('@{{ links.web }}')">
                <td>@{{ this.id }}</td>
                <td>@{{ this.date }}</td>
                <td>@{{ this.name }}</td>
                <td>@{{ this.debit }}</td>
                <td>@{{ this.credit }}</td>
                <td>@{{ this.balance }}</td>
            </tr>
        @{{/each}}
        </tbody>
        <tfoot>
            <tr>
                <th>@lang('Codigo de Operação')</th>
                <th>@lang('Data')</th>
                <th>@lang('Descrição')</th>
                <th>@lang('Débito')</th>
                <th>@lang('Crédito')</th>
                <th>@lang('Saldo')</th>
            </tr>
        </tfoot>
    </table>
</script>


@push('js')
<script type="text/javascript">
    $('.daterange').daterangepicker({
        locale: {
            applyLabel: 'Aplicar',
            cancelLabel: 'Cancelar',
            weekLabel: 'Sem',
            customRangeLabel: 'Definir datas',
        },
        ranges: {
            'Últimos 7 dias': [moment().subtract(6, 'days'), moment()],
            'Últimos 30 dias': [moment().subtract(29, 'days'), moment()],
            'Este Mês': [moment().startOf('month'), moment()],
            'Mês Passado': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'Este Ano': [moment().startOf('year'), moment()],
            'Ano passado': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
        },
        startDate: moment().subtract(29, 'days'),
        endDate: moment()
    }, function (start, end) {
        fetchData({
            'from': start.toString(),
            'to': end.toString(),
        })
    })
</script>
@endpush
