@extends('layouts.app')
@section('title', 'Dashboard')

@section('content_header')
<div class="container-fluid">
    <div class="row mb-2">
        <div class="col-6">
            <h1>@lang('Meu Painel')</h1>
        </div>
        <div class="col-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item active">@lang('Home')</li>
            </ol>
        </div>
    </div>
</div>
@stop

@section('content')
<div class="container-fluid">
    <div class="row">
                                @can('issue-basicsale')
                                <div class="col">
                                    <a href="{{ route('web.sales.basic.create') }}">
                                        <div class="shadow p-2 mb-3 rounded"style="text-align: center; background-color: #2abcc8">
                                            <img src="{{ asset('icons/venda_simples.png') }}" width="140" />
                                            <h4 style="color:white" class="bg-silver">@lang('Venda básica')</h4>
                                        </div>
                                    </a>
                                </div>
                                @endcan




                              @can('issue-cashsale')

                                <div class="col">
                                 <a href="{{ route('web.sales.cashsale.create') }}">
                                    <div class="shadow p-2 mb-3 rounded"style="text-align: center; background-color: #2aa173">
                                        <img src="{{ asset('icons/vd.png') }}" width="140" />
                                        <h4 style="color:white">@lang('Venda dinheiro')</h4>
                                    </div>
                                 </a>
                                </div>

                              @endcan


                               @can('issue-delivery_note')

                                     <div class="col">
                                        <a href="{{ route('web.sales.delivery_note.create') }}">
                                            <div class="shadow p-2 mb-3 rounded" style="text-align: center; background-color: #ffa95f">
                                            <img src="{{ asset('icons/delivery.png') }}" width="140" />
                                                <h4 style="color:white">@lang('Guia de Remessa')</h4>
                                            </div>
                                        </a>
                                    </div>

                               @endcan

                                @can('issue-invoice')

                                <div class="col">
                                 <a href="{{ route('web.sales.invoice.create') }}">
                                    <div class="shadow p-2 mb-3 rounded"style="text-align: center; background-color: #db765a">
                                        <img src="{{ asset('icons/invoice.png') }}" width="140" />
                                        <h4 style="color:white">@lang('Fatura')</h4>
                                    </div>
                                 </a>
                                </div>

                                @endcan

    </div>
    <div class="row">

                                @can('issue-proforma')
                                <div class="col">
                                 <a href="{{ route('web.sales.proforma.create') }}">
                                    <div class="shadow p-2 mb-3 rounded"style="text-align: center; background-color: #b2bec1">
                                        <img src="{{ asset('icons/proforma2.png') }}" width="140" />
                                        <h4 style="color:white">@lang('Proforma')</h4>
                                    </div>
                                 </a>
                                </div>
                                @endcan


                                @can('issue-recipt')
                                <div class="col">
                                 <a href="{{ route('web.sales.recipt.create') }}">
                                    <div class="shadow p-2 mb-3 rounded"style="text-align: center; background-color: #c9e568">
                                        <img src="{{ asset('icons/recipt.png') }}" width="140" />
                                        <h4 style="color:white">@lang('Recibo')</h4>
                                    </div>
                                 </a>
                                </div>
                                @endcan


                                @can('issue-creditnote')
                                <div class="col">
                                 <a href="{{ route('web.sales.creditnote.create') }}">
                                    <div class="shadow p-2 mb-3 rounded"style="text-align: center; background-color: #3d8ac7">
                                        <img src="{{ asset('icons/credit.png') }}" width="140" />
                                        <h4 style="color:white">@lang('Notas de Crédito')</h4>
                                    </div>
                                 </a>
                                </div>
                                @endcan

                                @can('issue-debitnote')
                                <div class="col">
                                 <a href="{{ route('web.sales.debitnote.create') }}">
                                    <div class="shadow p-2 mb-3 rounded"style="text-align: center; background-color: #cb4844">
                                        <img src="{{ asset('icons/debit-card.png') }}" width="140" />
                                        <h4 style="color:white">@lang('Nota de débito')</h4>
                                    </div>
                                 </a>
                                </div>
                                @endcan


    </div>
    <div class="row">
                            @can('manage-shifts')
                                   <div class="col-3">
                                 <a href="{{ route('web.sales.returns.create') }}">
                                    <div class="shadow p-2 mb-3 rounded"style="text-align: center; background-color: #00c4a4">
                                        <img src="{{ asset('icons/money-back.png') }}" width="140" />
                                        <h4 style="color:white">@lang('menu.Retorno')</h4>
                                    </div>
                                 </a>
                                </div>
                            @endcan

    </div>

    {{--  @include('dashboard.parts.main-stats')  --}}
</div>
@endsection
