<section class="col-md-8 connectedSortable">
    <!-- USERS LIST -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">@lang('Usuários')</h3>

            <div class="card-tools">
                <span class="badge badge-success">{{ $company->activeUsers()->count() }} @lang('Usuários em turno')</span>
                <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i>
                </button>
                <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i>
                </button>
            </div>
        </div>
        <!-- /.card-header -->
        <div class="card-body p-0">
            <ul class="users-list clearfix">
                @foreach ($company->activeUsers()->take(8)->get() as $user)
                <li>
                    <img src="{{ $user->profilePhoto() }}" alt="User Image">
                    <a class="users-list-name" href="#">{{ $user->name }}</a>
                    <span class="users-list-date">{{ $user->hasOpenShift()? 'Em turno': '' }}</span>
                </li>
                @endforeach
            </ul>
            <!-- /.users-list -->
        </div>
    </div>
    <!--/.card -->

</section>
