<section class="col-md-8 connectedSortable">
    <div class="card">
        <div class="card-header border-0">
            <h3 class="card-title">@lang('Produtos quase sem estoque')</h3>
        </div>
        <div class="card-body p-0">

            <table class="sb-datatable export excel pdf table table-bordered table-striped table-valign-middle display compact">
                <thead>
                    <tr>
                        <th>@lang('Code')</th>
                        <th>@lang('Produto')</th>
                        <th>@lang('Preço')</th>
                        <th>@lang('Quantidade')</th>
                        {{-- <th>@lang('Total faturado')</th> --}}
                    </tr>
                </thead>
                <tbody>

                    @foreach ($saleables as $saleable )

                        <tr>
                            <td>{{ $saleable->code }}</td>
                            <td>{{ $saleable->name }}</td>
                            <td>{{ $saleable->price }}</td>
                            <td>{{ number_format($saleable->qty) }}</td>
                        </tr>

                    @endforeach

                </tbody>

            </table>

        </div>
    </div>

</section>

{{-- @section('plugins.Handlebars', true)
<script id="table-template" type="text/x-handlebars-template">
    <table class="sb-datatable export excel pdf table table-bordered table-striped table-valign-middle display compact">
        <thead>
            <tr>
                <th>@lang('Produto')</th>
                <th>@lang('Preço')</th>
                <th>@lang('Quantidade')</th>
                <th>@lang('Total faturado')</th>
            </tr>
        </thead>
        <tbody>

            @{{#each items }}
                <tr>
                    <td>@{{ this.name }}</td>
                    <td>@{{ this.price }}</td>
                    <td>@{{ this.sales.quantity }}</td>
                    <td>@{{ this.sales.amount }}</td>
                </tr>
            @{{/each}}
        </tbody>

    </table>
</script>

@push('js')
<script type="text/javascript">
    $(document).ready(function () {
        $.ajax({
            ...ajaxSettings,
            method: 'GET',
            url: "{{ URL::signedRoute('api.stock.saleable.sales.report') }}",
            beforeSend: function () {

            },
            statusCode: {
                200: function (response) {
                    let data = response.data.sort((a,b) => {
                        return a.sales.quantity < b.sales.quantity;
                    })

                    data = data.map(a=>{
                        return {
                            name: a.name,
                            price: formatCurrencyNumber(a.price),
                            sales : {
                                quantity: formatNumber(a.sales.quantity, navigator.language, {
                                    style: 'decimal'
                                }),
                                amount: formatCurrencyNumber(a.sales.amount),
                            }
                        }
                    })

                    // Here we have to get the first 20 results
                    data = data.slice(0, 20)
                    renderTable(data)
                },
                401: (response) => {
                    $.ajax({
                        url: "{{ URL::signedRoute('web.system.exit') }}",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reloasd();
                            }, 1500);
                        }
                    });
                },

            },
        });
    });

    function renderTable(data){
        handlebar.init(data);
    }

    let handlebar = {
        init: function (list) {
            this.cacheDOM();
            this.render(list);
        },
        cacheDOM: function () {
            this.$tableContainer = $('#table');
        },
        render: function (list) {
            var template = Handlebars.compile($("#table-template").html());
            var context = {
                'items': list
            };
            var html = template(context);
            this.$tableContainer.html(html);

            if (list.length) {
                this.$tableContainer.show();
            } else {
                this.$tableContainer.hide();
            }
        },
    };

</script>
@endpush --}}
