@section('plugins.Chartjs', true)
@section('plugins.JqueryUI', true)
@push('js')
<script type="text/javascript">
    $.widget.bridge('uibutton', $.ui.button)
    // Make the dashboard widgets sortable Using jquery UI
    $('.connectedSortable').sortable({
        placeholder: 'sort-highlight',
        connectWith: '.connectedSortable',
        handle: '.card-header, .nav-tabs',
        forcePlaceholderSize: true,
        zIndex: 999999
    })
    $('.connectedSortable .card-header, .connectedSortable .nav-tabs-custo').css('cursor', 'move')
</script>
@endpush

@push('js')
<script type="text/javascript">
    $(document).ready(function () {
    $.ajax({
        ...ajaxSettings,
        method: 'GET',
        url: "{{ URL::signedRoute('api.reports.sales.current.month', ['company' => $company->id]) }}",
        beforeSend: function () {
            $('#main-chart-loader').removeClass('d-none');
            $('#main-chart').addClass('d-none');
        },
        statusCode: {
            202: function (response) {
                $('#main-chart-loader').addClass('d-none');
                $('#main-chart').removeClass('d-none');
                $('.sale-description').html('Entradas de ' + response.reference.from + ' a ' + response.reference.to)
                renderSalesChart(response);
                renderStats(response);
            },
            401: (response) => {
                $.ajax({
                    url: "{{ URL::signedRoute('web.system.exit') }}",
                    dataType: "HTML",
                    success: function (response) {
                        setTimeout(() => {
                            reload();
                        }, 1500);
                    }
                });
            },

        },
    });
});

function renderSalesChart(data) {
    'use strict'
    /* ChartJS
     * -------
     * Here we will create a few charts using ChartJS
    */

    //-----------------------
    //- MONTHLY SALES CHART -
    //-----------------------

    // Get context with jQuery - using jQuery's .get() method.

    var salesChartCanvas = $('#salesChart').get(0).getContext('2d')
    var counter = 0;
    var colors = shuffle(systemcolors)

    const lines = data.data.map((item) => {
        let color = colors[counter++]
        return {
            label: item.name,
            data: item.values,
            pointRadius: 3,
            pointHoverRadius:7,
            pointHighlightFill: '#fff',

            backgroundColor: color,
            borderColor: color,
            pointColor: color,
            pointStrokeColor: color,
            pointHighlightStroke: color,
        }
    });

    var salesChartData = {
        labels: data.keys,
        datasets: lines
    }

    var salesChartOptions = {
        maintainAspectRatio: false,
        responsive: true,
        legend: {
            display: true
        },
        scales: {
            xAxes: [{
                gridLines: {
                    display: false,
                }
            }],
            yAxes: [{
                gridLines: {
                    display: false,
                }
            }]
        }
    }

    // This will get the first returned node in the jQuery collection.
    var salesChart = new Chart(salesChartCanvas, {
        type: 'line',
        data: salesChartData,
        options: salesChartOptions
    })
}

function renderStats(data) {
    var total = data.total
    data = data.data

    let html = ''
    for (let i = 0; i < data.length; i++) {
        let percentage = 0
        if (!total)
            total = 0;
        else
            percentage = data[i].total / total * 100

        html = html + '<div class="progress-group">' + data[i].name +
            '<span class="float-right"><b>' + formatCurrencyNumber(data[i].total) + '</b>/' + formatCurrencyNumber(total) + '</span>' +
            '<div class="progress progress-sm">' +
            '<div class="progress-bar bg-' + classes[i] + '" style="width: ' + formatCurrencyNumber(percentage) + '%"></div>' +
            '</div>' +
            '</div>';
    }

    $('#stats').html(html)


    html = '<div class="col-md-6">'+
        '<div class="info-box bg-'+classes[0]+'">'+
        '<span class="info-box-icon">'+
        '<i class="far fa-copy"></i>'+
        '</span>'+
        '<div class="info-box-content">'+
        '<span class="info-box-text">Total em vendas</span>'+
        '<span class="info-box-number">'+formatCurrencyNumber(total)+'</span>'+
        '</div>'+
        '</div>'+
        '</div>'

    for (let i = 0; i < data.length; i++) {
        html = html + '<div class="col-md-6 "><div class="info-box  bg-'+classes[i+1]+'">' +
            '<span class="info-box-icon"><i class="far fa-copy"></i></span>' +
            '' +
            '<div class="info-box-content">' +
            '<span class="info-box-text">'+ data[i].name +'</span>' +
            '<span class="info-box-number">' + formatCurrencyNumber(data[i].total) +'</span>' +
            '</div>' +
            '</div>' +
            '</div>';
    }

    $('#card-stats').html(html)
}
</script>
@endpush