@extends('adminlte::page')

@section('meta_tags')
<meta name="api" content="{{ session('api') }}">
<link rel="shortcut icon" href="{{ secure_asset('favicon.jpg') }}">
@endsection

@section('right-sidebar')

<div class="p-3 control-sidebar-content">
    <h5>@lang('Opções')</h5>
    <hr class="border border-white border-bottom-0">

    @can('manage-local')
    <h6>@lang('Configurações empresarial')</h6>
    <div class="mb-1">
        <a href="{{ URL::signedRoute('web.company.brunch.show', ['brunch'=> Auth::user()->company->id]) }}">
            @lang('Minhas sucursal')
        </a>
    </div>
    @can('funcionality-basicsale')
    <div class="mb-1"><a
            href="{{ URL::signedRoute('web.company.brunch.configuration.index', ['brunch'=> Auth::user()->company->id]) }}">@lang('Configuração
            básica')</a></div>
    @endcan
    @can('funcionality-crm')
    <div class="mb-1"><a
            href="{{ URL::signedRoute('web.company.brunch.crm.index', ['brunch'=> Auth::user()->company->id]) }}">@lang('CRM')</a>
    </div>

    @endcan
    @endcan


    @can('manage-global')
    <hr class="border border-white border-bottom-0">
    <h6>@lang('Master configuration')</h6>
    <div class="mb-1"><a href="{{ URL::signedRoute('web.system.home') }}">@lang('Information')</a></div>
    @endcan
</div>
@endsection

@section('footer')
<div class="float-right d-none d-sm-block">
    <b>@lang('Version')</b> {{ config('app.version') }}
</div>
<strong>Copyright © 2019-{{ now()->format('Y') }} <a href="{{ config('app.authors.url') }}">{{
        config('app.authors.name') }}</a>.</strong> @lang('All rights
reserved').
@endsection

@push('js')
<script>
    $(document).ready(function () {
        $('.nav-sidebar > .nav-item > .nav-link.active')[0].scrollIntoView()
    });
</script>
@endpush