<div>
    <form wire:submit.prevent='checkExpiredSaleable'>

        <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <div class="card card-primary card-outline">
                            <div class="card-header">
                                <h3 class="card-title">@lang('Informações')</h3>
                            </div>
                            <div class="card-body">
                                    <div class="row">
                                        <div class="form-group col-sm-4" wire:ignore>
                                            <label for="unit_amount">@lang('Armazem')</label>
                                            <select wire:model='warehouse' class="selectpicker  form-control remove-example"
                                                    data-style="btn-outline-primary" data-size="7"
                                                    data-live-search="true" name="guias"
                                                    required  id="dataPicker2" autocomplete="off">
                                                    <option value="dafault" selected></option>
                                                    @foreach ($warehouses as $warehouse)
                                                              <option value="{{ $warehouse->id }}" >{{ $warehouse->name }}</option>
                                                    @endforeach

                                            </select>
                                        </div>
                                        <div class="form-group col">
                                            <label for="quantity">@lang('Data')</label>
                                            <input type="date" name="quantity" class="form-control" id="quantity" placeholder="1"
                                                value="1" wire:model='date' required>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-12">
                                                <button type="submit"
                                                class="btn btn-sm btn-outline-primary save">
                                                @lang('Adicionar')
                                                </button>
                                        </div>
                                    </div>
                                    <div wire:loading wire:target="checkExpiredSaleable">
                                            <div class="spinner-border text-success" role="status">
                                                <span class="sr-only">Loading...</span>
                                            </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
        </div>
    </form>


    <div class="container-fluid">

                   <div class="row">
                        <div class="col">
                           <table id="customers" class="table table-striped shadow p-3 mb-5 bg-white rounded">
                                <thead>
                                    <tr>
                                    <th scope="col">@lang('Codigo')</th>
                                    <th scope="col">@lang('Produto')</th>
                                    <th scope="col">@lang('Stock')</th>
                                        <th scope="col">@lang('Ultimo Movimento')</th>
                                    <th scope="col">@lang('Data de validade')</th>
                                    </tr>
                                </thead>
                                <tbody>
                                @foreach ($stockmoves as  $stockmove )
                                            @if(is_object($stockmove))

                                            <tr>
                                                <th scope="row">{{ $stockmove->code }}</th>
                                                <td>{{ $stockmove->name }}</td>
                                                <td>{{ $stockmove->balance }}</td>
                                                <td>{{ number_format($stockmove->lastmove)}}</td>
                                                <td>{{ $stockmove->movedate }}</td>
                                            </tr>

                                            @endif
                                @endforeach
                                </tbody>
                            </table>
                        </div>

                        <div col="col">
                           {{--  <div class="shadow p-3 mb-2 bg-red rounded">
                            <a href="#"><i class="fas fa-file-pdf fa-2x" ></i></a>
                           </div>  --}}
                           <div class="shadow p-3 mb-2 bg-green rounded" wire:click='exportExcel'>
                            <a href="#"> <i class="fas fa-file-excel fa-2x"></i></a>
                           </div>
                            <div wire:loading wire:target="exportExcel" style="padding-left: 4px">
                                            <div class="spinner-border text-warning center" role="status">
                                                <span class="sr-only">Loading...</span>
                                            </div>
                            </div>
                        </div>
                   </div>

                

        <style>

                #customers td, #customers th {
                border: 1px solid #ddd;
                padding: 8px;
                }

                #customers tr:nth-child(even){background-color: #f2f2f2;}

                #customers tr:hover {background-color: #ddd;}

                #customers th {
                padding-top: 12px;
                padding-bottom: 12px;
                text-align: left;
                background-color: #04AA6D;
                color: white;
                }

        </style>


</div>

