<div>

    {{-- selectpicker  --}}
    <form wire:submit.prevent='modal' id="invoiceBydelivery" class="card card-primary card-outline card-outline-tabs p-5">

        <div class="row">

            <div class="form-group col-sm-4" wire:ignore>
                <label for="cliente">@lang('Cliente')</label>
                <select class="selectpicker form-control" data-style="btn-outline-primary" data-size="4"
                    data-live-search="true" name="cliente" wire:model="customers_id" required
                    wire:change='onChangeCustomers' id="dataPicker1" title="Buscar Cliente">

                    @foreach ($customers as $customer)
                    <option value="{{ $customer->id }}"  data-tokens="{{ $customer->code }}" wire:key='{{ $customer->id }}'
                        @if ($customer->invoices->isNotEmpty())
                            hasBills=1
                        @endif
                        >
                        {{ $customer->name }} </option>
                    @endforeach
                </select>
                <div wire:loading wire:target="onChangeCustomers">
                    <div class="spinner-border text-warning" role="status">
                        <span class="sr-only">Loading...</span>
                      </div>
                </div>
            </div>

            <div class="form-group col-sm-4" wire:ignore>
                <label for="cliente">@lang('Guias de Remessas')</label>
                <select wire:model='delivers_id' class="selectpicker  form-control remove-example"
                        data-style="btn-outline-primary" data-size="1"
                        data-live-search="true" name="guias" multiple
                        required title="Digite o codigo da guia aqui" id="dataPicker2" autocomplete="off">
                        <option></option>
                    @foreach ($delivers as $delivery )

                    <option value="{{ $delivery->id }}" wire:key='{{ $delivery->id }}'>{{ $delivery->name() }}</option>

                    @endforeach
                </select>
            </div>

            <div class="form-group col-sm-4">
                <label for="cliente" style="color: red">@lang('Guias não faturadas')</label>
                <select class="form-control" data-style="btn-outline-primary"  name="guias" aria-readonly="true"  multiple>
                    @foreach ($customerDelivery as $delivery )

                    <option aria-readonly="true">{{ $delivery }}</option>

                    @endforeach
                </select>
            </div>



            <div class="form-group col-sm-12">
                <label for="obs">@lang('Observação')</label>
                <textarea wire:model='obs' class="form-control" rows="2" name="obs" placeholder="Observação..."></textarea>
            </div>

        </div>


        <div class="row">
            <div class="col-12">
                <button  type="submit"  class="btn bg-gradient-cyan">@lang('Emitir a factura')</button>
                <div wire:loading wire:target="modal">
                    <div class="spinner-border text-warning" role="status">
                        <span class="sr-only">Loading...</span>
                      </div>
                </div>
            </div>
        </div>
    </form>



  @if ($show)
  <div class="card card-primary card-outline card-outline-tabs p-5">

    <h5 class="modal-title mb-2" id="exampleModalLabel">
        <button wire:click='finalizar'   type="button" class="btn btn-outline-success" data-dismiss="modal">@lang('Finalizar')</button>
        <button wire:click='finalizar_imprimir' type="submit" class="btn btn-outline-info" data-dismiss="modal" >@lang('Finalizar e Imprimir')</button>
        &nbsp;
        <div wire:loading wire:target="finalizar_imprimir">
            <div class="spinner-border text-warning" role="status">
                <span class="sr-only">Loading...</span>
              </div>
        </div>
        <div wire:loading wire:target="finalizar">
            <div class="spinner-border text-warning" role="status">
                <span class="sr-only">Loading...</span>
              </div>
        </div>
      <div wire:loading wire:target="editar">
          <div class="spinner-border text-success" role="status">
              <span class="sr-only">Loading...</span>
            </div>
      </div>
      <button wire:click='fechar'    type="button" class="btn btn-outline-warning float-right" data-dismiss="modal">@lang('Cancelar')</button>
    </h5>




    <dl class="row">

        <div class="col-sm-6 col-md-4">
            <dt>@lang('Documento')</dt>
            <dd>Factura Baseada Em Guia</dd>
        </div>

        <div class="col-sm-6 col-md-4">
            <dt>@lang('Prazo de pagamento')</dt>
            <dd>@lang('Não especificado ')</dd>
        </div>



        <div class="col-sm-6 col-md-4">
            <dt>@lang('Valor total')</dt>
            <dd>{{ number_format($total, 2) }}</dd>
        </div>
        <div class="col-sm-6 col-md-4">
            <dt>@lang('Guias de Remessas')</dt>
            @foreach ($deliveryName as $deli )
            <dd>{{$deli}}</dd>
            @endforeach

        </div>

        <div class="col-sm-6 col-md-4">
            <dt>@lang('Cliente')</dt>

            <dd>{{ $customerName }}</dd>

        </div>

        <div class="col-sm-6 col-md-4">
            <dt>@lang('NUIT')</dt>
            <dd>{{ $customerNuit}}</dd>
        </div>


    </dl>
    <div class="row">
        <div class="col-12 table-responsive">
            <table class="table table-sm table-body table-bordered my-1 mt-3">
                <thead class="">
                    <tr>
                        <th class="text-left;">@lang('Codigo')</th>
                        <th class="text-left;">@lang('Artigo')</th>
                        <th class="text-center">@lang('Preço')</th>
                        <th class="text-center">@lang('Qty')</th>
                        <th class="text-center">@lang('Desconto')</th>
                        <th class="text-center">@lang('IVA') %</th>
                        <th class="text-center">@lang('Subtotal')</th>
                    </tr>
                </thead>
                <tbody>
                            @foreach ($deliveryNotesItems as $item)
                                @if (is_object($item))
                                    <tr>
                                        <td class="text-left">{{ $item->sale_code }}</td>
                                        <td class="text-left">{{ $item->sale_name }}</td>
                                        <td class="text-right">{{ number_format($item->unit_amount,  2) }}</td>
                                        <td class="text-right">{{ number_format($item->quantity) }}</td>
                                        <td class="text-right">{{ number_format($item->discount, 2) }}</td>
                                        <td class="text-right">{{ number_format($item->vat_tax, 2) }}</td>
                                        <td class="text-right">{{ number_format($item->totalAmount(), 2) }}</td>
                                    </tr>
                                @endif
                            @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
  @endif





    <script type="text/javascript">

        document.addEventListener('livewire:update', function () {



                if (@this.show) {



                        $("#dataPicker1").val('default');
                        $("#dataPicker1").selectpicker("refresh");

                        $("#dataPicker2").val('default');
                        $("#dataPicker2").selectpicker("refresh");

                        $('.selectpiker').selectpicker('deselectAll');

                        // $("#myModal").modal();
                }


                if (@this.is_customer_changed) {


                            console.log(@this.deliveryNotesItems);

                            let array = @this.customerDelivery;

                            array.forEach(element => {
                                console.log(element);

                            });

                    }


        });



    </script>




</div>


