
 <div class="row">
    <div class="col-md-12">
        <div class="card card-primary card-outline card-outline-tabs">
            <div class="card-header p-0 border-bottom-0">
                <ul class="nav nav-tabs" id="custom-tabs-three-tab" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" id="custom-tabs-three-home-tab" data-toggle="pill"
                            href="#custom-tabs-three-home" role="tab" aria-controls="custom-tabs-three-home"
                            aria-selected="false">@lang('Criação Básica')</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link " id="custom-tabs-three-profile-tab" data-toggle="pill"
                            href="#custom-tabs-three-profile" role="tab" aria-controls="custom-tabs-three-profile"
                            aria-selected="true">@lang('Importação')</a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link " id="custom-tabs-three-example-tab" data-toggle="pill"
                            href="#custom-tabs-three-example" role="tab" aria-controls="custom-tabs-three-example"
                            aria-selected="true">@lang('Exemplo de ficheiro')</a>
                    </li>
                </ul>
            </div>
            <div class="card-body">
                <div class="tab-content" id="custom-tabs-three-tabContent">
                    <div class="tab-pane fade active show" id="custom-tabs-three-home" role="tabpanel"
                        aria-labelledby="custom-tabs-three-home-tab">
                        @include('stock.saleable.create.parts.form')
                    </div>
                    <div class="tab-pane fade " id="custom-tabs-three-profile" role="tabpanel"
                        aria-labelledby="custom-tabs-three-profile-tab">
                        @include('stock.saleable.create.parts.import')
                    </div>

                    <div class="tab-pane fade " id="custom-tabs-three-example" role="tabpanel"
                        aria-labelledby="custom-tabs-three-example-tab">
                        <a href="{{ secure_asset('importers\product-import.xlsx') }}" type="button" class="btn btn-primary">@lang('Excel')</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md">

        <div>


            <div class="card card-primary card-outline ">
                {{-- modal --}}
                @include('livewire.tempsaleables.modal.modal')
                <div class="card-header p-4 border-bottom-0">
                    @if ($temp_saleables->count()>0)
                        <h5 class="card-title">
                            <Button class="btn btn-outline-success " wire:click='finalizar'>
                                Finalizar Entradas
                            </Button>
                            <Button class="btn btn-outline-danger mr-4" wire:click='cancelar'>
                                Cancelar
                            </Button>

                        </h5>
                    @endif

                        <div wire:loading wire:target="remover">
                            <div class="spinner-border text-success" role="status">
                                <span class="sr-only">Loading...</span>
                              </div>
                        </div>
                        <div wire:loading wire:target="finalizar">
                            <div class="spinner-border text-warning" role="status">
                                <span class="sr-only">Loading...</span>
                              </div>
                        </div>
                        <div wire:loading wire:target="cancelar">
                            <div class="spinner-border text-warning" role="status">
                                <span class="sr-only">Loading...</span>
                              </div>
                        </div>

                    <div class="float-right">

                        <input wire:model='search' type="text" class="form-control float-right" placeholder="Buscar Produtos temporarios">

                    </div>

                </div>
                <div class="card-body center">
                    <div class="container table-responsive">

                        @if ($temp_saleables->count()>0)
                            <table class="table table-center bg-white mb-0">
                                <thead>
                                    <tr class="fw-bold">
                                        <th class="p-3">Codigo</th>

                                        <th class="p-3">
                                                    <span >Produto</span>
                                        </th>
                                        <th class="p-3">
                                            <span >Preço unitário</span>
                                        </th>
                                        <th class=" p-3">
                                            @lang('Opções')
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ( $temp_saleables as $item )
                                    <tr class="fw-bold">
                                        <td class="p-3">{{ $item->code }}</td>

                                        <td class="p-3">
                                                    <span >{{ $item->name }}</span>
                                        </td>
                                        <td class="p-3">
                                            <span >{{ $item->price }}</span>
                                        </td>
                                        <td class=" p-3">
                                            <button type="button" class="btn btn-outline-danger btn-sm delete" wire:click='remover({{ $item->id }})'>
                                                <span class="badge" ><i class="fa fa-trash"></i></span>
                                            </button>
                                            <button type="button" class="btn btn-outline-info btn-sm delete" wire:click='editar({{ $item->id }})' data-toggle="modal" data-target="#exampleModal">
                                                <span class="badge" ><i class="fa fa-edit"></i></span>
                                            </button>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        @endif

                    </div>
                </div>
            </div>



            <script type="text/javascript">

                document.addEventListener('livewire:update', function () {

                })




            </script>

        </div>


    </div>
</div>




