<div class="row">
    {{-- @include('reports.basicsales.parts.mini.filter-form') --}}
    @include('reports.basicsales.parts.mini.charts')
    @include('reports.basicsales.parts.mini.table')
</div>

@section('plugins.Chartjs', true)
@section('plugins.JqueryUI', true)
@section('plugins.Datepicker', true)


@push('js')
<script type="text/javascript">
    'use strict'
    $.widget.bridge('uibutton', $.ui.button)
// Make the dashboard widgets sortable Using jquery UI
$('.connectedSortable').sortable({
    placeholder: 'sort-highlight',
    connectWith: '.connectedSortable',
    handle: '.card-header, .nav-tabs',
    forcePlaceholderSize: true,
    zIndex: 999999
})
$('.connectedSortable .card-header, .connectedSortable .nav-tabs-custom').css('cursor', 'move')
</script>
@endpush


@push('js')
<script type="text/javascript" type="text/javascript">
    $('.daterange').daterangepicker({
            locale: {
                applyLabel: 'Aplicar',
                cancelLabel: 'Cancelar',
                weekLabel: 'Sem',
                customRangeLabel: 'Definir datas',
            },
            ranges: {
                'Hoje': [moment(), moment()],
                'Ontem': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Últimos 7 dias': [moment().subtract(6, 'days'), moment()],
                'Últimos 30 dias': [moment().subtract(29, 'days'), moment()],
                'Este Mês': [moment().startOf('month'), moment()],
                'Mês Passado': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
                'Este Ano': [moment().startOf('year'), moment()],
                'Ano passado': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
            },
            startDate: moment().subtract(29, 'days'),
            endDate: moment()
        }, function (start, end) {
            fetchData({
                'from': start.toString(),
                'to': end.toString(),
            })
        })
</script>
@endpush


@push('js')
<script type="text/javascript">
    var chart = null
        var table = null

        $(document).ready(fetchData({
            'from' : moment().startOf('month').toString(),
            'to' :  moment().toString()
        }));


        function fetchData(params) {
            $.ajax({
                ...ajaxSettings,
                method: 'GET',
                url: "{{ URL::signedRoute('api.reports.sales.basic.report', ['company' => $company->id]) }}",
                data: params,
                beforeSend: function () {
                    $('.12-months-sales .loader').removeClass('d-none');
                    $('.12-months-sales  canvas').addClass('d-none');
                },
                statusCode: {
                    202: function (response) {
                        $('.12-months-sales canvas').removeClass('d-none');
                        $('.12-months-sales .loader').addClass('d-none');

                        $('span.reference').html('Análise de '+response.reference.from + ' a '+response.reference.to+' Total de: '+formatCurrencyNumber((parseFloat(response.total)).toFixed(2)))

                        if (chart)
                            updateChart(response)
                        else
                            rendercharts(response)


                        if (table)
                            updateTable(response.data.data)
                        else
                            renderTable(response.data.data)
                    },
                    401: (response) => {
                        $.ajax({
                            url: "{{ URL::signedRoute('web.system.exit') }}",
                            dataType: "HTML",
                            success: function (response) {
                                setTimeout(() => {
                                    reload();
                                }, 1500);
                            }
                        });
                    },

                },
            });
        }


</script>
@endpush