<!DOCTYPE html>
<html>
<head>
    <title>{{ $customer->name }}</title>
</head>
<style type="text/css">
    body{
        font-family: 'Roboto Condensed', sans-serif;
    }
    .m-0{
        margin: 0px;
    }

    .p-0{
        padding: 0px;
    }
    .pt-5{
        padding-top:5px;
    }
    .mt-10{
        margin-top:10px;
    }
    .text-center{
        text-align:center !important;
    }
    .w-100{
        width: 100%;
    }
    .w-50{
        width:50%;
    }
    .w-85{
        width:85%;
    }
    .w-15{
        width:15%;
    }
    .logo img{
        width:45px;
        height:45px;
        padding-top:30px;
    }
    .logo span{
        margin-left:8px;
        top:19px;
        position: absolute;
        font-weight: bold;
        font-size:25px;
    }
    .gray-color{
        color:#5D5D5D;
    }
    .text-bold{
        font-weight: bold;
    }
    .border{
        border:1px solid black;
    }
    table tr,th,td{
        border: 1px solid #d2d2d2;
        border-collapse:collapse;
        padding:7px 8px;
    }
    table tr th{
        background: #F4F4F4;
        font-size:15px;
    }
    table tr td{
        font-size:13px;
    }
    table{
        border-collapse:collapse;
    }
    .box-text p{
        line-height:10px;
    }
    .float-left{
        float:left;
    }
    .float-right{
        float:right;
    }
    .total-part{
        font-size:16px;
        line-height:12px;
    }
    .total-right p{
        padding-right:20px;
    }
    .seller {
            float: right;
            font-size: 16px;
            margin-bottom: 30px;
    }
     .mt-50{
        margin-top: 50px;
        margin-bottom: 0px;
    }
</style>
<body>
<div class="head-title">

    <div class="text-center m-0 p-0" style="font-size: 14px">
        <img src="{{ $company->logoPhoto() }}" width="110" style="object-fit: scale-down;" />
        <p class="m-0 pt-5 text-bold w-100"><span class="gray-color">{{ $company->name }} </span></p>
    </div>

    <h4 class="text-center m-0 p-0"> @lang('Extrato') -

    @if($type=='geral')
        @lang('Geral')
    @endif
    @if($type=='invoice')
        @lang('Fatura')
    @endif
    @if($type=='cashSale')
        @lang('Venda Dinheiro')
    @endif

    @if($type=='deliveryNote')
        @lang('Guia de Remessa')
    @endif
    <br>{{ $from }} - {{ $to }}
    </h4>

</div>
<div class="add-detail mt-10">
    <div class="w-50 float-left mt-10" style="font-size: 14px">
        {{--  <img src="{{ $company->logoPhoto() }}" width="150" style="object-fit: scale-down;" />
        <p class="m-0 pt-5 text-bold w-100"><span class="gray-color">{{ $company->name }} </span></p>
        <p class="m-0 pt-5 text-bold w-100">@lang('NUIT'): <span class="gray-color">{{ $company->nuit }}</span></p>
        <p class="m-0 pt-5 text-bold w-100">@lang('Endereço'): <span class="gray-color">{{ $company->address }}</span></p>
        <p class="m-0 pt-5 text-bold w-100">@lang('Email'): <span class="gray-color">{{ $company->email }}</span></p>
         <p class="m-0 pt-5 text-bold w-100">@lang('Telefone'): <span class="gray-color">{{ $company->phone  }}</span></p>  --}}
    </div>
    <div class="inv">
          <div class="users">
            {{--  <div class="seller mt-50">
              <div><strong>@lang('Cliente')</strong></div>
              <div>{{ $customer->name }}</div>
              <div>{{ $customer->adress }}</div>
              <div>{{ $customer->phone }}</div>
            </div>  --}}
          </div>
    </div>
    <div style="clear: both;"></div>
</div>
<div class="table-section bill-tbl w-100 mt-10">
    <table class="table w-100 mt-10">
        <tr>
            <th class="w-50">@lang('De')</th>
            <th class="w-50">@lang('Para') (@lang('Cliente'))</th>
        </tr>
        <tr>
            <td>
                <div class="box-text">
                    <p class="m-0 pt-5 text-bold w-100"><span class="gray-color">{{ $company->name }} </span></p>
                    <p class="m-0 pt-5 text-bold w-100">@lang('NUIT'): <span class="gray-color">{{ $company->nuit }}</span></p>
                    <p class="m-0 pt-5 text-bold w-100">@lang('Endereço'): <span class="gray-color">{{ $company->address }}</span></p>
                    <p class="m-0 pt-5 text-bold w-100">@lang('Email'): <span class="gray-color">{{ $company->email }}</span></p>
                    <p class="m-0 pt-5 text-bold w-100">@lang('Telefone'): <span class="gray-color">{{ $company->phone  }}</span></p>
                </div>
            </td>
            <td>
                <div class="box-text" >
                    <div><span class="m-0 pt-5 text-bold w-100">@lang('Nome'): </span>{{ $customer->name }}</div>
                    <div><span class="m-0 pt-5 text-bold w-100">@lang('Endereço'): </span>{{ $customer->adress }}</div>
                    <div><span class="m-0 pt-5 text-bold w-100">@lang('Telefone'): </span>{{ $customer->phone }}</div>
                </div>
            </td>
        </tr>
    </table>
</div>
{{-- <div class="table-section bill-tbl w-100 mt-10">
    <table class="table w-100 mt-10">
        <tr>
            <th class="w-50">@lang('Saldo em dívida')</th>
            <th class="w-50">@lang('Crédito a favor')</th>
        </tr>
        <tr>
            <td style="text-align: center">{{ number_format(00, 2) }}</td>
            <td style="text-align: center">{{ number_format(00, 2) }}</td>
        </tr>
    </table>
</div> --}}

     <main>
      <table class='mt-10 w-100'>
        <thead>
          <tr>
            <th>@lang('Ordem')</th>
            <th>@lang('Data de emissao')</th>
            <th>@lang('Documento')</th>
            <th>@lang('Valor Total')</th>
            <th>@lang('Valor pago')</th>
            <th>@lang('Valor Pendente')</th>
          </tr>
        </thead>
        <tbody>
          @foreach ($operations as $item)

            @if($item->name!='')


                    <tr style="text-align: center">
                        <td class="desc">{{ $item->id }}</td>
                        <td class="total">{{ $item->date }}</td>
                        <td class="total">{{ $item->name }}</td>
                        <td class="total">{{ number_format($item->totalamount)}}</td>


                        <td class="total">
                        @if($item->paidamount==0)
                                {{ number_format($item->credit) }}
                                @else
                                {{ $item->paidamount }}
                        @endif
                        </td>

                        <td class="total">{{ number_format($item->pendingamount) }}</td>

                    </tr>

            @endif

          @endforeach
          <tr style="background-color:#f5f5f5">
            <td colspan="5" class="grand total"><strong>@lang('Total')</strong></td>
            <td class="grand total" style="text-align: center"><strong>{{number_format($total,2)}}</strong></td>
          </tr>
          <tr style="background-color:#dcfce4">
            <td colspan="5" class="grand total" ><strong>@lang('Total Pago')</strong></td>
            <td class="grand total" style="text-align: center"><strong>{{number_format($paidamount,2)}}</strong></td>
          </tr>
          <tr style="background-color:#fce5e1">
            <td colspan="5" class="grand total" ><strong>@lang('Total') @lang('Valor Pendente')</strong></td>
            <td class="grand total" style="text-align: center"><strong>{{number_format($pendingamount,2)}}</strong></td>
          </tr>
        </tbody>
      </table>



      <!--Bank details -->



         <div class="notice" style="font-size: 12px">

            <sub>{{ config("app.name") }}, @lang('Licenciado a') {{ $company->name }}<br>@lang('Processado por computador') </sub>


         </div>




     </main>

</html>

