<section class="col-lg-12 connectedSortable">
    <!-- Custom tabs (Charts with tabs)-->
    <div class="card bg-gradient-info">
        <div class="card-header border-0">
            <h3 class="card-title">
                <i class="fas fa-chart-pie mr-1"></i>
                @lang('Guia de remessas') <span class="reference"></span>
            </h3>
            <div class="card-tools">

                <button type="button " class="btn btn-info btn-sm daterange" data-toggle="tooltip" title="Date range">
                    <i class="far fa-calendar-alt"></i>
                </button>

                <button type="button" class="btn bg-info btn-sm" data-card-widget="collapse">
                    <i class="fas fa-minus"></i>
                </button>
                <button type="button" class="btn bg-info btn-sm" data-card-widget="remove">
                    <i class="fas fa-times"></i>
                </button>

            </div>
        </div><!-- /.card-header -->
        <div class="card-body 12-months-sales">
            <!-- Morris chart - Sales -->
            <div class="chart" id="revenue-chart" style="position: relative; height: 300px;">
                <div class="loader text-center">
                    <i class="fa fa-spinner fa-spin fa-4x" aria-hidden="true"></i>
                </div>

                <canvas id="12months-liner" height="300" style="height: 300px;"></canvas>
            </div>

        </div>
    </div>
    <!-- /.card -->
</section>


@push('js')
<script type="text/javascript">
    function rendercharts(data) {
        var salesChartCanvas = $('#12months-liner').get(0).getContext('2d')
        var counter = 0;

        const lines = data.report.values.map((item) => {
            return {
                label: item.name,
                data: item.values,
                fill: false,
                borderWidth: 2,
                lineTension: 0,
                spanGaps: true,
                borderColor: '#efefef',
                pointRadius: 3,
                pointHoverRadius: 7,
                pointColor: '#efefef',
                pointBackgroundColor: '#efefef',
            }
        });

        var salesChartData = {
            labels: data.report.keys,
            datasets: lines
        }

        var salesChartOptions = {
            maintainAspectRatio: false,
            responsive: true,
            legend: {
                display: false,
            },
            scales: {
                xAxes: [{
                    ticks: {
                        fontColor: '#efefef',
                    },
                    gridLines: {
                        display: false,
                        color: '#efefef',
                        drawBorder: false,
                    }
                }],
                yAxes: [{
                    ticks: {

                        fontColor: '#efefef',
                    },
                    gridLines: {
                        display: true,
                        color: '#efefef',
                        drawBorder: false,
                    }
                }]
            }
        }

        // This will get the first returned node in the jQuery collection.
        var salesChart = chart = new Chart(salesChartCanvas, {
            type: 'line',
            data: salesChartData,
            options: salesChartOptions,
        })

    }

    function updateChart(data) {

        const lines = data.report.values.map((item) => {
            return {
                label: item.name,
                data: item.values,
                fill: false,
                borderWidth: 2,
                lineTension: 0,
                spanGaps: true,
                borderColor: '#efefef',
                pointRadius: 3,
                pointHoverRadius: 7,
                pointColor: '#efefef',
                pointBackgroundColor: '#efefef',
            }
        });

        data = {
            labels: data.report.keys,
            datasets : lines
        }
        chart.data.labels = data.labels
        chart.data.datasets = data.datasets
        chart.update()
    }
</script>
@endpush
