<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">@lang('Informações da venda')</h3>
                </div>
                <div class="card-body">
                    <form role="form" method="POST" id="generate-report"
                        action="{{ URL::route('web.sales.report.generate.pdf') }}">
                        @csrf
                        <div class="row">
                            <div class="form-group col-sm-4">
                                <label for="documents">@lang('Documentos a incluir')</label>

                                <select class="selectpicker form-control" multiple data-style="btn-outline-primary"
                                    data-size="8" data-live-search="true" id="documents" name="documents[]"
                                    data-actions-box="true" title="Indique os documentos">
                                    @if($company->hasFuncBasic_sale())
                                    <option value="1" data-tokens="">@lang('Vendas Básicas')</option>
                                    @endif

                                    @if($company->hasFuncInvoice())
                                    <option value="2" data-tokens="">@lang('Faturas')</option>
                                    @endif



                                    @if($company->hasFuncRecipt())
                                    <option value="3" data-tokens="">@lang('Recibos')</option>
                                    @endif

                                    @if($company->hasFuncDebit_note())
                                    <option value="4" data-tokens="">@lang('NC')</option>
                                    @endif

                                    @if($company->hasFuncCredit_note())
                                    <option value="5" data-tokens="">@lang('ND')</option>
                                    @endif

                                    @if($company->hasFuncCash_sale())
                                    <option value="6" data-tokens="">@lang('Venda Dinheiro')</option>
                                    @endif

                                    @if ($company->hasFuncDelivery_note())
                                       <option value="7" data-tokens="">@lang('Guia De Remessa')</option>
                                    @endif

                                    @if($company->hasFuncInvoice())
                                    <option value="8" data-tokens="">@lang('Faturas/Guias')</option>
                                    @endif

                                </select>
                            </div>


                            <div class="form-group col-sm-4">
                                <label for="period_from">@lang('Data Inicial')</label>
                                <input type="date" max="{{ now() }}" name="period_from" class="form-control"
                                    id="period_from" placeholder="Data Inicial">
                            </div>

                            <div class="form-group col-sm-4">
                                <label for="period_to">@lang('Data final')</label>
                                <input type="date" max="{{ now()->endOfMOnth() }}" name="period_to" class="form-control"
                                    id="period_to" placeholder="Data final">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <a href="#" target="blank">

                                    <button type="submit"
                                    class="btn btn-sm btn-outline-primary save">@lang('Imprimir')</button>

                                </a>



                                <button type="button"
                                    class="btn btn-sm btn-outline-success d-none saved">@lang('Processado')</button>
                                <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                                        class="fa fa-spinner fa-spin fa-circle-notch"
                                        aria-hidden="true"></i>@lang('Processando')</button>
                                <button type="button"
                                    class="btn btn-sm btn-outline-danger d-none error">@lang('Erro')</button>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
</div>

@section('plugins.JqueryValidation', true)
@section('plugins.BootstrapSwitch', true)
@section('plugins.Sweetalert2', true)
@section('plugins.SelectPicker', true)
@push('js')
<script type="text/javascript">
    $(document).ready(function () {
    $('#generate-report').validate({
        rules: {
            documents: {
                required: true,
            },
            period_from: {
                required: true,
                date: true,
            },
            period_to: {
                required: true,
                date: true,
            },
        },
        messages: {
            quantity: {
                required: 'Este campo é obrigatório',
                min: 'Deve ser no mínimo zero'
            },
            discount: {
                min: 'Deve ser no mínimo zero'
            },
        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
            $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
            $(element).removeClass('is-invalid');
        }
    });
});
</script>
@endpush
