<form role="form" class="" id="finalize-invoice">
    <div class="row">
        <div class="form-group col-sm-4">
            <label for="gender">@lang('Cliente')</label>
            <select class="selectpicker form-control" data-style="btn-outline-primary" data-size="4" required
                data-live-search="true" name="customer">
                @foreach ($customers as $customer)
                <option value="{{ $customer->id }}" data-tokens="{{ $customer->code }}">
                    {{ $customer->name }} </option>
                @endforeach
            </select>
        </div>

        <div class="form-group col-sm-4">
            <label for="discount">@lang('Desconto')</label>
            <input type="text" name="discount" class="form-control" id="discount" placeholder="1500" value="0">
        </div>

        <div class="form-group col-sm-4">
            <label for="due_date">@lang('Prazo de pagamento')</label>
            <input type="date" name="due_date" class="form-control" id="due_date" placeholder="1500" value="">
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <button type="button" class="btn btn-sm btn-outline-primary save ">@lang('Finalizar')</button>
            <button type="button" class="btn btn-sm btn-outline-info save-print">@lang('Finalizar e
                Imprimir')</button>
            <button type="button" class="btn btn-sm btn-outline-success d-none saved">@lang('Finalizado')</button>
            <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                    class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i>@lang('Finalizando')</button>
            <button type="button" class="btn btn-sm btn-outline-danger d-none error">@lang('Erro')</button>
        </div>
    </div>

</form>

@push('js')
<script type="text/javascript">
    var print = false;
$(document).on('click', 'form#finalize-invoice button.save', function (event) {
    print = false;
    finalizeSale()
    event.stopPropagation()
});
$(document).on('click', 'form#finalize-invoice button.save-print', function (event) {
    print = true;
    finalizeSale();
    event.stopPropagation()
});

function finalizeSale() {
    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
    });
    let data = $('form#finalize-invoice').serializeArray();

    $.ajax({
        ...ajaxSettings,
        method: 'PUT',
        url: "{{ URL::signedRoute('api.reports.generator.update', ['invoice'=> $invoice->id]) }}",
        data: data,
        beforeSend: function () {

            $('form#finalize-invoice button.save').addClass('d-none');
            $('form#finalize-invoice button.saved').addClass('d-none');
            $('form#finalize-invoice button.error').addClass('d-none');
            $('form#finalize-invoice button.saving').removeClass('d-none');
        },
        statusCode: {
            202: function (response) {
                Toast.fire({
                    type: 'success',
                    title: '@lang("Entradas finalizadas").'
                });

                $('form#finalize-invoice button.save').addClass('d-none');
                $('form#finalize-invoice button.saved').removeClass('d-none');
                $('form#finalize-invoice button.saving').addClass('d-none');
                $('form#finalize-invoice button.error').addClass('d-none');


                if (print)
                    goto('{{ URL::signedRoute('web.reports.generator.print', ['invoice'=> $invoice->id]) }}')
                else{
                    reload()
                }

            },
            403: () => {
                reload();
            },
            401: (response) => {

                Toast.fire({
                    type: 'error',
                    title: '@lang("Volte a fazer o login").'
                })

                $.ajax({
                    url: "{{ URL::signedRoute('web.system.exit') }}",
                    dataType: "HTML",
                    success: function (response) {
                        setTimeout(() => {
                            reload();
                        }, 1500);
                    }
                });
            }
        },
        error: (response) => {
            $('form#finalize-invoice button.save').addClass('d-none');
            $('form#finalize-invoice button.saved').addClass('d-none');
            $('form#finalize-invoice button.saving').addClass('d-none');
            $('form#finalize-invoice button.error').removeClass('d-none');
            setTimeout(() => {
                $('form#finalize-invoice button.save').removeClass('d-none');
                $('form#finalize-invoice button.saved').addClass('d-none');
                $('form#finalize-invoice button.saving').addClass('d-none');
                $('form#finalize-invoice button.error').addClass('d-none');
            }, 2000)
        }
    });
}
</script>
@endpush