<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    @include('reports.generator.pdf.style')
    <style>
        .page-break {
            page-break-after: always;
        }

       @media print {
            .new-page {
                page-break-before: always;
            }
        }
    </style>
</head>

<body style="font-size: 13px;">

    <div class="container-fluid">
        <div class="float-left w-60 text-left">

            <img src="{{ $company->logoPhoto() }}" width="150" style="object-fit: scale-down;" />

            <br><b>{{ $company->name }}</b><br>
            <b>{{ $company->nuit }}</b> <br>
            {{ $company->address }}<br>
            {{ $company->email }}<br>
            {{ $company->phone }}
            <br>
        </div>

        <div class="float-right w-40 text-right">
            <table class="table table-sm">
                <tbody>
                    <tr>
                        <td colspan="2" class="border-0 text-center"><b>@lang('Relatorio de vendas'): </b></td>
                    </tr>
                    <tr class="border-0 ">
                        <td class="border-0 text-left text-bold">@lang('Início')</td>
                        <td class="border-0 text-right">{{ $from->format('d-m-Y') }}</td>
                    </tr>
                    <tr class="border-0 ">
                        <td class="border-0 text-left text-bold">@lang('Fim')</td>
                        <td class="border-0 text-right">{{ $to->format('d-m-Y') }}</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>


    <div class="container-fluid" style="margin-top: 68px;">

        <div class="table-responsive mt-3">
            <br>
             <br> <br> <br> <br> <br>  <br> <br>
            <table class="table table-sm table-body table-bordered mb-1 mt-10">
                <thead class="">
                    <tr>
                        <th class="text-left text-bold">@lang('Tipos de Documentos')</th>
                        <th class="text-right text-bold">@lang('Valor')</th>
                    </tr>
                </thead>
                <tbody>

                    @if ($includeBasicSales)
                    <tr>
                        <td class="text-left">Venda básica</td>
                        <td class="text-right">{{ number_format($basicsAmount, 2) }}</td>
                    </tr>
                    @endif

                    @if ($includeCashSales)
                    <tr>
                        <td class="text-left">@lang('Venda dinheiro')</td>
                        <td class="text-right">{{ number_format( $cashSalesAmount, 2) }}</td>
                    </tr>
                    @endif

                    @if ($includeInvoices || $includeInvoicebydelivery)

                    @if ($includeReceipts)
                            <tr>
                                <td class="text-left">@lang('Facturas')</td>
                                <td class="text-right">{{ number_format(($invoicesAmount-$receiptsAmount)+$invoiceBydeliveryAmount, 2) }}</td>
                            </tr>
                        @else

                        <tr>
                            <td class="text-left">@lang('Facturas')</td>
                            <td class="text-right">{{ number_format($invoicesAmount+$invoiceBydeliveryAmount, 2) }}</td>
                        </tr>

                    @endif

                    @endif

                    {{-- @if ($includeInvoicebydelivery)
                    <tr>
                        <td class="text-left">@lang('Facturas/Guias')</td>
                        <td class="text-right">{{ number_format($invoiceBydeliveryAmount, 2) }}</td>
                    </tr>
                    @endif --}}

                    @if ($includeReceipts)
                    <tr>
                        <td class="text-left">@lang('Recibos')</td>
                        <td class="text-right">{{ number_format($receiptsAmount, 2) }}</td>
                    </tr>
                    @endif

                    @if ($includeDelivery)
                    <tr>
                        <td class="text-left">@lang('Guias de Remessas')</td>
                        <td class="text-right">{{ number_format($deliveryAmount-$invoiceBydeliveryAmount, 2) }}</td>
                    </tr>
                    @endif

                    <tr class="bg-green">

                        <td style="text-align: right; font-weight: bold;">@lang('Total de entradas'): </td>
                        <td colspan="1" style="text-align: right; font-weight: bold; color:white;">{{ number_format($basicsAmount+$cashSalesAmount+$receiptsAmount, 2, ',', ' ') }} MZN
                        </td>

                    </tr>

                    <tr class="bg-red">
                        <td  style="text-align: right; font-weight: bold; color:white">@lang('Total de saídas'): </td>

                        @if ($includeReceipts)

                                <td class="text-right">{{ number_format((($invoicesAmount+$invoiceBydeliveryAmount)-$receiptsAmount)+($deliveryAmount-$invoiceBydeliveryAmount), 2, ',', ' ') }} MZN</td>
                        @else
                                <td class="text-right">{{ number_format(($deliveryAmount-$invoiceBydeliveryAmount)+$invoicesAmount+$invoiceBydeliveryAmount, 2, ',', ' ') }} MZN</td>
                         @endif
                    </tr>
                </tbody>

            </table>


            <table class="mt-3" style="display: none">
                <tr>
                    <td><sub>{{ config("app.name") }}, @lang('Licença')
                            <span class="text-bold text-sm">{{ config("app.finance_dep_global_auth") }}</span> /
                            {{ Auth::user()->brunch->daf_auth }} </sub></td>
                </tr>
            </table>

            <div style="margin-top: 18px; margin-bottom: 20px;">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th style=" text-align: left;">@lang('Código')</th>
                                    <th style=" text-align: left;">@lang('Produto')</th>
                                    <th style=" text-align: center;">@lang('Preço')</th>
                                    <th style=" text-align: center;">@lang('Qty')</th>
                                    <th style=" text-align: center;">@lang('Total (Mzn)')</th>
                                    <th style=" text-align: center;">@lang('Estoque')</th>
                                    <th>&nbsp;&nbsp;</th>
                                </tr>
                            </thead>
                            <tbody>

                                @foreach ($allItems  as  $key => $saleable)
                                        <tr>
                                            <td style=" text-align: left;">{{ $saleable->sale_code }}</td>
                                            <td style=" text-align: left;">{{ $saleable->sale_name }}</td>
                                            <td style=" text-align: center;">{{ number_format($saleable->unit_amount, 2) }}</td>

                                            <td style=" text-align: center;">
                                                {{ number_format($saleable->quantity) }}
                                            </td>
                                            <td style=" text-align: center;">{{ number_format($saleable->total, 2) }}</td>
                                            <td style=" text-align: center;">{{ number_format(Auth::user()->company->getLastStock($saleable->saleable_id, $from, $to)) }}</td>
                                            <td>&nbsp;&nbsp;</td>
                                        </tr>


                                @endforeach

                            </tbody>

                        </table>
            </div>
        </div>
    </div>


    <div class="container-fluid">

        <table class="" width="100%">
            <tr>
                 <td width="30%"
                    style="border-top: 1px solid #000000; font-size: 9pt; text-align: left; padding-top: 3mm; ">
                    <span class="d-none"> @lang('Pagina') . ' {PAGENO} ' .@lang('de') . ' {nb}</span>

                    <i>{{ config('app.name') }}, @lang('Licenciado a') <strong>{{$company->name}}</strong></i>

                    <br>
                    <sub> {{ config("app.finance_dep_global_auth") }}
                    </sub>
                    <br>
                    <sub>@lang('Processado por computador')</sub>
                </td>

                <td width="40%" class="text-right">
                    &nbsp;
                </td>

                <td width="30%"
                    style="border-top: 1px solid #000000; font-size: 9pt; padding-top: 3mm;  text-align: right;">
                    @lang('Impresso por'): {{ Auth::user()->name }}<br><span
                        style="font-size: 7pt;">{{ now()->format('d/m/Y') }}</span>
                </td>
            </tr>
        </table>
    </div>

</body>

</html>
