<section class="col-lg-12 connectedSortable">
    <!-- Custom tabs (Charts with tabs)-->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">
                <i class="fas fa-chart-pie mr-1"></i>
                @lang('Vendas últimos 12 meses')
            </h3>
            <div class="card-tools">
                <ul class="nav nav-pills ml-auto">
                    <li class="nav-item">
                        <a class="nav-link active" href="#revenue-chart" data-toggle="tab">@lang('Análise mensal')</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#sales-chart" data-toggle="tab">@lang('Análise global')</a>
                    </li>

                    <li class="nav-item">
                        <button type="button" class="btn bg-default btn-sm" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                    </li>
                    <li class="nav-item">
                        <button type="button" class="btn bg-default btn-sm" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                        </button>
                    </li>

                </ul>

            </div>
        </div><!-- /.card-header -->
        <div class="card-body">
            <div class="tab-content p-0 12-months-sales">
                <!-- Morris chart - Sales -->
                <div class="chart tab-pane active" id="revenue-chart" style="position: relative; height: 300px;">
                    <div class="loader text-center">
                        <i class="fa fa-spinner fa-spin fa-4x" aria-hidden="true"></i>
                    </div>
                    <canvas id="12months-liner" height="300" style="height: 300px;"></canvas>
                </div>

                <div class="chart tab-pane pie" id="sales-chart" style="position: relative; height: 300px;">
                    <div class="row">
                        <div class="col-12 loader">
                            <div class="text-center">
                                <i class="fa fa-spinner fa-spin fa-4x" aria-hidden="true"></i>
                            </div>
                        </div>

                        <div class="col-6">
                            <div class="chart" style="position: relative; height: 300px;">
                                <canvas height="300" style="height: 300px;"></canvas>
                            </div>
                        </div>

                        <div class="col-6">
                            <div class="chart" style="position: relative; height: 300px;">
                                <canvas height="300" style="height: 300px;"></canvas>
                            </div>
                        </div>
                    </div>



                </div>
            </div>
        </div><!-- /.card-body -->
    </div>
    <!-- /.card -->
</section>


@push('js')
<script type="text/javascript">
    $(document).ready(function () {
    $.ajax({
        ...ajaxSettings,
        method: 'GET',
        url: "{{ URL::signedRoute('api.reports.sales.last.year', ['company' => $company->id]) }}",
        beforeSend: function () {
            $('.12-months-sales .loader').removeClass('d-none');
            $('.12-months-sales  canvas').addClass('d-none');
        },
        statusCode: {
            202: function (response) {
                $('.12-months-sales .loader').addClass('d-none');
                $('.12-months-sales canvas').removeClass('d-none');

                renderliner(response);
                renderPie(response);
            },
            401: (response) => {
                $.ajax({
                    url: "{{ URL::signedRoute('web.system.exit') }}",
                    dataType: "HTML",
                    success: function (response) {
                        setTimeout(() => {
                            reload();
                        }, 1500);
                    }
                });
            },

        },
    });
});

function renderliner(data) {
    'use strict'

    var salesChartCanvas = $('#12months-liner').get(0).getContext('2d')
    var counter = 0;
    var colors = shuffle(systemcolors)

    const lines = data.data.map((item) => {
        let color = colors[counter++]
        return {
            label: item.name,
            data: item.values,
            pointRadius: 2,
            pointHoverRadius:7,

            pointHighlightFill: '#fff',

            backgroundColor: color,
            borderColor: color,
            pointColor: color,
            pointStrokeColor: color,
            pointHighlightStroke: color,
        }
    });

    var salesChartData = {
        labels: data.keys,
        datasets: lines
    }

    var salesChartOptions = {
        maintainAspectRatio: false,
        responsive: true,
        legend: {
            display: true
        },
        scales: {
            xAxes: [{
                gridLines: {
                    display: false,
                }
            }],
            yAxes: [{
                gridLines: {
                    display: false,
                }
            }]
        }
    }

    // This will get the first returned node in the jQuery collection.
    var salesChart = new Chart(salesChartCanvas, {
        type: 'line',
        data: salesChartData,
        options: salesChartOptions
    })
}
function renderPie(data) {

var pieDivided = $('.12-months-sales .pie canvas').get(0).getContext('2d')
var pieGlobal = $('.12-months-sales .pie canvas').get(1).getContext('2d')

var total = data.total

let labels = []
let values = []
var colors = []
let temp = shuffle(systemcolors)


data.data.forEach((element, index) => {
    labels.push(element.name + ' ('+ element.total +')')
    colors.push(temp[index])
    if (!total)
        total = 1;
    let percentage = element.total / total * 100
    values.push(percentage)
});

var pieData = {
    labels: labels,
    datasets: [
        {
            data: values,
            backgroundColor: colors,
        }
    ]
}
var pieOptions = {
    legend: {
        display: true
    },
    maintainAspectRatio: false,
    responsive: true,
}
//Create pie or douhnut chart
// You can switch between pie and douhnut using the method below.
var pieChart = new Chart(pieDivided, {
    type: 'doughnut',
    data: pieData,
    options: pieOptions
});

var newPie = new Chart(pieGlobal, {
    type: 'pie',
    data: {
        labels: ['Total'],
        datasets: [
        {
            data: [total],
            backgroundColor: ['#dc3545'],
        }
    ]

    },
    options: pieOptions
});
}

</script>
@endpush
