<section class="col-lg-6 connectedSortable">
    <!-- solid sales graph -->
    <div class="card bg-gradient-info">
        <div class="card-header border-0">
            <h3 class="card-title">
                <i class="fas fa-th mr-1"></i>
                @lang('Apenas este ano')
            </h3>

            <div class="card-tools">
                <button type="button" class="btn bg-info btn-sm" data-card-widget="collapse">
                    <i class="fas fa-minus"></i>
                </button>
                <button type="button" class="btn bg-info btn-sm" data-card-widget="remove">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        </div>
        <div class="card-body year-sales">

            <div class="loader text-center">
                <i class="fa fa-spinner fa-spin fa-4x" aria-hidden="true"></i>
            </div>

            <canvas class="chart" id="line-chart"
                style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
        </div>
        <!-- /.card-body -->
        <div class="card-footer bg-transparent d-none">
            <div class="row">
                <div class="col-4 text-center">
                    <input type="text" class="knob" data-readonly="true" value="20" data-width="60" data-height="60"
                        data-fgColor="#39CCCC">

                    <div class="text-white">Mail-Orders</div>
                </div>
                <!-- ./col -->
                <div class="col-4 text-center">
                    <input type="text" class="knob" data-readonly="true" value="50" data-width="60" data-height="60"
                        data-fgColor="#39CCCC">

                    <div class="text-white">Online</div>
                </div>
                <!-- ./col -->
                <div class="col-4 text-center">
                    <input type="text" class="knob" data-readonly="true" value="30" data-width="60" data-height="60"
                        data-fgColor="#39CCCC">

                    <div class="text-white">In-Store</div>
                </div>
                <!-- ./col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.card-footer -->
    </div>
    <!-- /.card -->
</section>



@push('js')
<script type="text/javascript">
    $(document).ready(function () {
    $.ajax({
        ...ajaxSettings,
        method: 'GET',
        url: "{{ URL::signedRoute('api.reports.sales.current.year', ['company' => $company->id]) }}",
        beforeSend: function () {
            $('.year-sales .loader').removeClass('d-none');
            $('.year-sales  canvas').addClass('d-none');
        },
        statusCode: {
            202: function (response) {
                $('.year-sales .loader').addClass('d-none');
                $('.year-sales canvas').removeClass('d-none');

                renderYearliner(response);
            },
            401: (response) => {
                $.ajax({
                    url: "{{ URL::signedRoute('web.system.exit') }}",
                    dataType: "HTML",
                    success: function (response) {
                        setTimeout(() => {
                            reload();
                        }, 1500);
                    }
                });
            },

        },
    });
});

function renderYearliner(data) {
    'use strict'

    var salesChartCanvas = $('.year-sales  canvas').get(0).getContext('2d')
    var counter = 0;
    var colors = shuffle(systemcolors)

    const lines = data.data.map((item) => {
        let color = colors[counter++]
        return {
            label: item.name,
            data: item.values,

            fill: false,
            borderWidth: 2,
            lineTension: 0,
            spanGaps: true,
            borderColor: '#efefef',
            pointRadius: 3,
            pointHoverRadius: 7,
            pointColor: '#efefef',
            pointBackgroundColor: '#efefef',
        }
    });

    var salesChartData = {
        labels: data.keys,
        datasets: lines
    }

    var salesChartOptions = {
        maintainAspectRatio: false,
        responsive: true,
        legend: {
            display: false
        },
        scales: {
            xAxes: [{
                ticks: {
                    fontColor: '#efefef',
                },
                gridLines: {
                    display: false,
                    color: '#efefef',
                    drawBorder: false,
                }
            }],
            yAxes: [{
                ticks: {

                    fontColor: '#efefef',
                },
                gridLines: {
                    display: true,
                    color: '#efefef',
                    drawBorder: false,
                }
            }]
        }
    }

    // This will get the first returned node in the jQuery collection.
    var salesChart = new Chart(salesChartCanvas, {
        type: 'line',
        data: salesChartData,
        options: salesChartOptions
    })
}

</script>
@endpush
