<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">@lang('Informações da venda')</h3>
                </div>
                <div class="card-body">
                    <form role="form" id="create-creditnote-sale">
                        <div class="row">
                            <div class="form-group col-sm-4">
                                <label for="gender">@lang('Produto')</label>
                                <select class="selectpicker form-control" data-style="btn-outline-primary" data-size="4"
                                    data-live-search="true" name="saleable">
                                    <option value="" data-tokens="">@lang('Diversos')</option>

                                    @foreach ($saleables as $saleable)
                                    <option value="{{ $saleable->id }}" data-tokens="{{ $saleable->code }}">
                                        {{ $saleable->name }} </option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group col-sm-2">
                                <label for="quantity">@lang('Quantidade')</label>
                                <input type="text" name="quantity" class="form-control" id="quantity" placeholder="1"
                                    value="1">
                            </div>



                            <div class="form-group col-sm-4">
                                <label for="unit_amount">@lang('Preço unitário')</label>
                                <input type="text" name="unit_amount" class="form-control" id="unit_amount"
                                    placeholder="1500">
                            </div>

                            <div class="form-group col-sm-2">
                                <label for="discount">@lang('Desconto')</label>
                                <input type="text" name="discount" class="form-control" id="discount" placeholder="1500"
                                    value="0">
                            </div>


                            <div class="form-group col-sm-4">
                                <label for="sale_name">@lang('Nome')</label>
                                <input type="text" name="sale_name" class="form-control" id="sale_name"
                                    placeholder="Nome alternativo">
                            </div>

                            <div class="form-group col-sm-4">
                                <label for="sale_code">@lang('Codigo')</label>
                                <input type="text" name="sale_code" class="form-control" id="sale_code"
                                    placeholder="Codigo alternativo">
                            </div>

                            <div class="form-group col-sm-4">
                                <label for="vat_tax">@lang('IVA')</label>
                                <input type="text" name="vat_tax" class="form-control" id="vat_tax"
                                    placeholder="Iva alternativo">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <button type="submit"
                                    class="btn btn-sm btn-outline-primary save">@lang('Adicionar')</button>
                                <button type="button"
                                    class="btn btn-sm btn-outline-success d-none saved">@lang('Adicionado')</button>
                                <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                                        class="fa fa-spinner fa-spin fa-circle-notch"
                                        aria-hidden="true"></i>@lang('Adicionando')</button>
                                <button type="button"
                                    class="btn btn-sm btn-outline-danger d-none error">@lang('Erro')</button>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
</div>

@section('plugins.JqueryValidation', true)
@section('plugins.BootstrapSwitch', true)
@section('plugins.Sweetalert2', true)
@section('plugins.SelectPicker', true)
@push('js')
<script type="text/javascript">
    $(document).ready(function () {
    $.validator.setDefaults({
        submitHandler: saveCompanyData
    });

    $('#create-creditnote-sale').validate({
        rules: {
            quantity: {
                required: true,
                min: 0
            },
            discount: {
                min: 0
            },
        },
        messages: {
            quantity: {
                required: 'Este campo é obrigatório',
                min: 'Deve ser no mínimo zero'
            },
            discount: {
                min: 'Deve ser no mínimo zero'
            },
        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
            $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
            $(element).removeClass('is-invalid');
        }
    });
});

$(document).ready(checkSelectedOption);

$('select[name="saleable"]').change(checkSelectedOption);

function checkSelectedOption() {
    const items = JSON.parse('{!! $saleables !!}')
    const value =  $('select[name="saleable"]').val();

    let searcher = new Searchable(items)

    let saleable = searcher.data(value);
    if (saleable) {
        render(saleable)
    }
}

function render(saleable) {
    $('input[name="unit_amount"]').val(saleable.price);
    $('input[name="sale_name"]').val(saleable.name);
    $('input[name="sale_code"]').val(saleable.code);
    $('input[name="vat_tax"]').val(saleable.vat_scheme.tax);
}

function saveCompanyData() {
    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
    });

    let data = $('form#create-creditnote-sale').serializeArray();

    $.ajax({
        ...ajaxSettings,
        method: 'POST',
        url: "{{ URL::signedRoute('api.sales.creditnote.item.store', ['creditnote' => $creditnote->id]) }}",
        data: data,
        beforeSend: function () {
            $('form#create-creditnote-sale button.save').addClass('d-none');
            $('form#create-creditnote-sale button.saved').addClass('d-none');
            $('form#create-creditnote-sale button.error').addClass('d-none');
            $('form#create-creditnote-sale button.saving').removeClass('d-none');
        },
        statusCode: {
            201: function (response) {
                Toast.fire({
                    type: 'success',
                    title: '@lang("Item added").'
                })

                $('form#create-creditnote-sale button.save').removeClass('d-none');
                $('form#create-creditnote-sale button.saved').addClass('d-none');
                $('form#create-creditnote-sale button.saving').addClass('d-none');
                $('form#create-creditnote-sale button.error').addClass('d-none');
                handlebar.init(response.body.items);
            },
            401: (response) => {

                Toast.fire({
                    type: 'error',
                    title: '@lang("Volte a fazer o login").'
                })

                $.ajax({
                    url: "{{ URL::signedRoute('web.system.exit') }}",
                    dataType: "HTML",
                    success: function (response) {
                        setTimeout(() => {
                            reload();
                        }, 1500);
                    }
                });
            },
            403: () => {
                reload();
            },
            422: (response) => {
                Toast.fire({
                    type: 'error',
                    title: '@lang("Verifique os dados inseridos e submeta outra vez").'
                })

                $('form#create-creditnote-sale button.save').removeClass('d-none');
                $('form#create-creditnote-sale button.saved').addClass('d-none');
                $('form#create-creditnote-sale button.saving').addClass('d-none');
                $('form#create-creditnote-sale button.error').addClass('d-none');
            },
        },
        error: (response) => {
            $('form#create-creditnote-sale button.save').addClass('d-none');
            $('form#create-creditnote-sale button.saved').addClass('d-none');
            $('form#create-creditnote-sale button.saving').addClass('d-none');
            $('form#create-creditnote-sale button.error').removeClass('d-none');
            setTimeout(() => {
                $('form#create-creditnote-sale button.save').removeClass('d-none');
                $('form#create-creditnote-sale button.saved').addClass('d-none');
                $('form#create-creditnote-sale button.saving').addClass('d-none');
                $('form#create-creditnote-sale button.error').addClass('d-none');
            }, 2000)
        }
    });
}
</script>
@endpush
