<form role="form" class="" id="finalize-creditnote">
    <div class="row">
        <div class="form-group col-sm-4">
            <label for="gender">@lang('Cliente')</label>
            <select class="selectpicker form-control" data-style="btn-outline-primary" data-size="4" required
                data-live-search="true" name="customer">
                @foreach ($customers as $customer)
                <option value="{{ $customer->id }}" data-tokens="{{ $customer->code }}">
                    {{ $customer->name }} </option>
                @endforeach
            </select>
        </div>




        <div class="form-group col-sm-4">
            <label for="gender">@lang('Fatura')</label>
            <select class="selectpicker form-control" data-style="btn-outline-primary" data-size="4" required
                data-live-search="true" name="invoice">
            </select>
        </div>


        <div class="form-group col-sm-4">
            <label>&nbsp;&nbsp;</label>
            <div id="load-items">
                <button type="button" class="btn btn-sm btn-outline-primary load ">@lang('Carregar Itens')</button>
                <button type="button" class="btn btn-sm btn-outline-success d-none loaded">@lang('Carregado')</button>
                <button type="button" class="btn btn-sm btn-outline-warning d-none loading"><i
                        class="fa fa-spinner fa-spin fa-circle-notch"
                        aria-hidden="true"></i>@lang('Carregando')</button>
                <button type="button" class="btn btn-sm btn-outline-danger d-none error">@lang('Erro')</button>
            </div>
        </div>
    </div>
    <hr>
    <div class="row">
        <div class="form-group col-sm-3">
            <label for="discount">@lang('Desconto')</label>
            <input type="text" name="discount" class="form-control" id="discount" placeholder="1500"
                value="{{ $creditnote->financial_discount }}">
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <button type="button" class="btn btn-sm btn-outline-primary save ">@lang('Finalizar')</button>
            <button type="button" class="btn btn-sm btn-outline-info save-print">@lang('Finalizar e
                Imprimir')</button>
            <button type="button" class="btn btn-sm btn-outline-success d-none saved">@lang('Finalizado')</button>
            <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                    class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i>@lang('Finalizando')</button>
            <button type="button" class="btn btn-sm btn-outline-danger d-none error">@lang('Erro')</button>
        </div>
    </div>


</form>
{{-- 	 --}}
@push('js')
<script type="text/javascript">
    let customers = {!! $customers->toJson() !!}
    $(document).ready(function () {
        renderCustomerInvoices();

        $('select[name="customer"]').on('change', function () {
            renderCustomerInvoices();
        });
    });

    function renderCustomerInvoices(){
        let customer = $('select[name="customer"]').val();

        $('select[name="invoice"]').html('');
        $('select[name="invoice"]').selectpicker('render');
        $('select[name="invoice"]').selectpicker('refresh');


        let searcher = new Searchable(customers)
        let result = searcher.data(customer);
        if (result) {
            let data = result.invoices
            $.each(data, function () {
                var options = "<option " + "value='" + this.id + "'>" + this.code+"/"+this.validated_at.substring(0, 4)+ "</option>";
                $('select[name="invoice"]').append(options);
            });
            $('select[name="invoice"]').selectpicker('render');
            $('select[name="invoice"]').selectpicker('refresh');
        }
    }
</script>
@endpush

@push('js')
<script type="text/javascript">
    $(document).ready(function () {
        $('div#load-items button.load').click(function (e) {
            e.preventDefault();

            let url = window.location.protocol+"//"+window.location.hostname
            +"/api/sales/copy/invoice/"+$('select[name="invoice"]').val()+"/to/creditnote"

            $.ajax({
                ...ajaxSettings,
                method: 'POST',
                url: url,
                beforeSend: function () {
                    $('div#load-items button.load').addClass('d-none');
                    $('div#load-items button.loaded').addClass('d-none');
                    $('div#load-items button.error').addClass('d-none');
                    $('div#load-items button.loading').removeClass('d-none');
                },
                statusCode: {
                    403: () => {
                        reload();
                    },
                    401: (response) => {
                        Toast.fire({
                            type: 'error',
                            title: '@lang("Volte a fazer o login").'
                        })
                        $.ajax({
                            url: "{{ URL::signedRoute('web.system.exit') }}",
                            dataType: "HTML",
                            success: function (response) {
                                setTimeout(() => {
                                    reload();
                                }, 1500);
                            }
                        });
                    }
                },
                success:() => {
                    loadItems();

                    $('div#load-items button.load').addClass('d-none');
                    $('div#load-items button.loaded').removeClass('d-none');
                    $('div#load-items button.loading').addClass('d-none');
                    $('div#load-items button.error').addClass('d-none');
                    setTimeout(() => {
                        $('div#load-items button.load').removeClass('d-none');
                        $('div#load-items button.loaded').addClass('d-none');
                        $('div#load-items button.loading').addClass('d-none');
                        $('div#load-items button.error').addClass('d-none');
                    }, 2000)

                },
                error: (response) => {
                    $('div#load-items button.load').addClass('d-none');
                    $('div#load-items button.loaded').addClass('d-none');
                    $('div#load-items button.loading').addClass('d-none');
                    $('div#load-items button.error').removeClass('d-none');
                    setTimeout(() => {
                        $('div#load-items button.load').removeClass('d-none');
                        $('div#load-items button.loaded').addClass('d-none');
                        $('div#load-items button.loading').addClass('d-none');
                        $('div#load-items button.error').addClass('d-none');
                    }, 2000)
                }
            });
        });
    });
</script>
@endpush

@push('js')
<script type="text/javascript">
    var print = false;
$(document).on('click', 'form#finalize-creditnote button.save', function (event) {
    print = false;
    finalizeSale()
    event.stopPropagation()
});
$(document).on('click', 'form#finalize-creditnote button.save-print', function (event) {
    print = true;
    finalizeSale();
    event.stopPropagation()
});

function finalizeSale() {
    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
    });
    let data = $('form#finalize-creditnote').serializeArray();

    $.ajax({
        ...ajaxSettings,
        method: 'PUT',
        url: "{{ URL::signedRoute('api.sales.creditnote.update', ['creditnote'=> $creditnote->id]) }}",
        data: data,
        beforeSend: function () {

            $('form#finalize-creditnote button.save').addClass('d-none');
            $('form#finalize-creditnote button.saved').addClass('d-none');
            $('form#finalize-creditnote button.error').addClass('d-none');
            $('form#finalize-creditnote button.saving').removeClass('d-none');
        },
        statusCode: {
            202: function (response) {
                Toast.fire({
                    type: 'success',
                    title: '@lang("Entradas finalizadas").'
                });

                $('form#finalize-creditnote button.save').addClass('d-none');
                $('form#finalize-creditnote button.saved').removeClass('d-none');
                $('form#finalize-creditnote button.saving').addClass('d-none');
                $('form#finalize-creditnote button.error').addClass('d-none');


                if (print)
                    goto('{{ URL::signedRoute('web.sales.creditnote.print', ['creditnote'=> $creditnote->id]) }}')
                else{
                    reload()
                }

            },
            403: () => {
                reload();
            },
            401: (response) => {

                Toast.fire({
                    type: 'error',
                    title: '@lang("Volte a fazer o login").'
                })

                $.ajax({
                    url: "{{ URL::signedRoute('web.system.exit') }}",
                    dataType: "HTML",
                    success: function (response) {
                        setTimeout(() => {
                            reload();
                        }, 1500);
                    }
                });
            }
        },
        error: (response) => {
            $('form#finalize-creditnote button.save').addClass('d-none');
            $('form#finalize-creditnote button.saved').addClass('d-none');
            $('form#finalize-creditnote button.saving').addClass('d-none');
            $('form#finalize-creditnote button.error').removeClass('d-none');
            setTimeout(() => {
                $('form#finalize-creditnote button.save').removeClass('d-none');
                $('form#finalize-creditnote button.saved').addClass('d-none');
                $('form#finalize-creditnote button.saving').addClass('d-none');
                $('form#finalize-creditnote button.error').addClass('d-none');
            }, 2000)
        }
    });
}
</script>
@endpush
