<dl class="row">

    <div class="col-sm-6 col-md-4">
        <dt>@lang('Documento')</dt>
        <dd>{{ $deliveryNote->name() }}</dd>
    </div>
    <div class="col-sm-6 col-md-4">
        <dt>@lang('Data de emissão')</dt>
        <dd>{{ $deliveryNote->issueDate() }}</dd>
    </div>
    <div class="col-sm-6 col-md-4">
        <dt>@lang('Prazo de pagamento')</dt>
        <dd>{{ $deliveryNote->dueDate() }}</dd>
    </div>

    <div class="col-sm-6 col-md-4">
        <dt>@lang('Operador')</dt>
        <dd>{{ $deliveryNote->operator() }}</dd>
    </div>
    <div class="col-sm-6 col-md-4">
        <dt>@lang('Valor total')</dt>
        <dd>{{ number_format($deliveryNote->totalAmount(), 2) }}</dd>
    </div>


    @if (false)

    <div class="col-sm-6 col-md-4">
        <dt>@lang('Valor Pendente')</dt>
        <dd>{{ number_format($deliveryNote->pendingAmount(), 2) }}</dd>
    </div>

    @endif

</dl>

<dl class="row">
    <div class="col-sm-6 col-md-4">
        <dt>@lang('Cliente')</dt>
        @if ($deliveryNote->customer)
        <dd><a href="{{ URL::route('web.customer.show', ['customer'=>  $deliveryNote->customer->id]) }}">{{
                $deliveryNote->customer_name }}</a>
        </dd>
        @else
        <dd>{{ $deliveryNote->customer_name }}</dd>
        @endif
    </div>

    <div class="col-sm-6 col-md-4">
        <dt>@lang('NUIT')</dt>
        <dd>{{ $deliveryNote->customer_nuit }}</dd>
    </div>
    <div class="col-sm-6 col-md-4">
        <dt>@lang('Valor') &nbsp; @lang('Faturado')</dt>
        @if($deliveryNote->invoices->first() !=null)
                <dd style="backgroundcolor: red">{{ $deliveryNote->invoices->first()->totalAmount() }}</dd>
        @endif

    </div>

</dl>

@include('sales.delivery_note.show.parts.mini.btn')


<div class="row">
    <div class="col-12 table-responsive">
        <table class="table table-sm table-body table-bordered my-1 mt-3">
            <thead class="">
                <tr>
                    <th class="text-left;">@lang('Codigo')</th>
                    <th class="text-left;">@lang('Artigo')</th>
                    <th class="text-center">@lang('Preço')</th>
                    <th class="text-center">@lang('Qty')</th>
                    <th class="text-center">@lang('Desconto')</th>
                    <th class="text-center">@lang('IVA') %</th>
                    <th class="text-center">@lang('Subtotal')</th>
                </tr>
            </thead>
            <tbody>

                @foreach ($deliveryNote->saleItens as $item)
                <tr>
                    <td class="text-left">{{ $item->sale_code }}</td>
                    <td class="text-left">{{ $item->sale_name }}</td>
                    <td class="text-right">{{ number_format($item->unit_amount, 2) }}</td>
                    <td class="text-right">{{ number_format($item->quantity) }}</td>
                    <td class="text-right">{{ number_format($item->discount, 2) }}</td>
                    <td class="text-right">{{ number_format($item->vat_tax, 2) }}</td>
                    <td class="text-right">{{ number_format($item->totalAmount(), 2) }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@if ($deliveryNote->obs !=null)

<div class="row">
    <div class="col-12 table-responsive">
        <p class="text-justify text-xs"><span class="text-bold">OBS: </span> {{ $deliveryNote->obs }}</p>
    </div>
</div>
@endif


<div class="row">
    <div class="col-12">
        <div class="w-50 float-left mt-2">
            <table class="table table-bordered table-sm">
                <thead>
                    <tr>
                        <td colspan="4"><b>@lang('Resumo de IVA')</b>
                        </td>
                    </tr>
                    <tr>
                        <td class="text-right"><b>@lang('Taxa')</b></td>
                        <td class="text-right"><b>@lang('Incidência')</b></td>
                        <td class="text-right"><b>@lang('Total IVA')</b></td>
                        <td class="text-right"><b>@lang('Motivo de isenção')</b></td>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($deliveryNote->vatResume() as $item)
                    <tr>
                        <td class="text-right">{{ $item->vat_tax }}</td>
                        <td class="text-right">{{ number_format($item->incidence, 2) }}</td>
                        <td class="text-right">{{ number_format($item->total, 2) }}</td>
                        <td></td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        <div class="w-40 float-right mt-2">
            <table class="table table-sm">
                <tbody>
                    <tr class="">
                        <td>@lang('Mercadoria ou serviços')</td>
                        <td class="text-right">{{ number_format($deliveryNote->groceriesAndServices(),2) }}</td>
                    </tr>
                    <tr class="">
                        <td>@lang('Descontos comerciais')</td>
                        <td class="text-right">{{ number_format($deliveryNote->commercialDiscount(), 2) }}</td>
                    </tr>

                    <tr class="">
                        <td>@lang('Desconto financeiro')</td>
                        <td class="text-right">{{ number_format($deliveryNote->financial_discount) }}</td>
                    </tr>
                    <tr class="">
                        <td>@lang('IVA')</td>
                        <td class="text-right">{{ number_format($deliveryNote->vatResume()->sum('total'), 2) }}</td>
                    </tr>
                    <tr>
                        <td>@lang('Total MZN')</td>
                        <td class="text-right">{{ number_format($deliveryNote->totalAmount(), 2) }}</td>
                    </tr>
                </tbody>
            </table>
        </div>

    </div>

</div>
