@extends('layouts.app')
@section('title', 'Fatura')

@section('content_header')
<div class="container-fluid">
    <div class="row mb-2">
        <div class="col-sm-6">
            <h1>@lang('Fatura')</h1>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="{{ URL::signedRoute('web.system.home') }}">@lang('Home')</a></li>
                <li class="breadcrumb-item"><a href="{{ URL::signedRoute('web.sales.invoice.index') }}">@lang('Faturas')</a></li>
                <li class="breadcrumb-item active">@lang('Nova venda')</li>
            </ol>
        </div>
    </div>
</div>
@stop

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div>
                <div class="card-header p-0 border-bottom-0">
                    <ul class="nav nav-tabs" id="custom-tabs-three-tab" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" id="custom-tabs-three-home-tab" data-toggle="pill"
                                href="#custom-tabs-three-home" role="tab" aria-controls="custom-tabs-three-home"
                                aria-selected="false">@lang('Normal')</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link " id="custom-tabs-three-profile-tab" data-toggle="pill"
                                href="#custom-tabs-three-profile" role="tab" aria-controls="custom-tabs-three-profile"
                                aria-selected="true">@lang('Por Guia')</a>
                        </li>

                    </ul>
                </div>

                <div class="card-body">
                    <div class="tab-content" id="custom-tabs-three-tabContent">
                        <div class="tab-pane fade active show" id="custom-tabs-three-home" role="tabpanel"
                            aria-labelledby="custom-tabs-three-home-tab">
                            @include('sales.invoice.create.parts.form')
                            @include('sales.invoice.create.parts.handlebars')
                        </div>
                        <div class="tab-pane fade " id="custom-tabs-three-profile" role="tabpanel"
                            aria-labelledby="custom-tabs-three-profile-tab">
                            <livewire:invoice-by-delivery-note.invoice-by-delivery-note>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


@endsection
