<form role="form" class="" id="finalize-proforma">
    <div class="row">
        <div class="form-group col-sm-3">
            <label for="gender">@lang('Cliente')</label>
            <select class="selectpicker form-control" data-style="btn-outline-primary" data-size="4" required
                data-live-search="true" name="customer">
                <option value="" data-tokens="Passagem">Passagem</option>
                @foreach ($customers as $customer)
                <option value="{{ $customer->id }}" data-tokens="{{ $customer->code }}">
                    {{ $customer->name }} </option>
                @endforeach
            </select>
        </div>


        <div class="form-group col-sm-3">
            <label for="customer_name">@lang('Nome do cliente')</label>
            <input type="text" name="customer_name" class="form-control" id="customer_name" placeholder="1500">
        </div>

        <div class="form-group col-sm-3">
            <label for="customer_nuit">@lang('NUIT do cliente')</label>
            <input type="text" name="customer_nuit" class="form-control" id="customer_nuit" placeholder="123456789" value="">
        </div>
        <div class="form-group col-sm-3">
            <label for="customer_address">@lang('Endereço')</label>
            <input type="text" name="customer_address" class="form-control" id="customer_address" placeholder="BCI0001"
                value="">
        </div>

        <div class="form-group col-sm-4">
            <label for="due_date">@lang('Prazo de pagamento')</label>
            <input type="date" name="due_date" class="form-control" id="due_date" placeholder="1500" value="">
        </div>

        <div class="form-group col-sm-12">
            <label for="obs">@lang('Observação')</label>
            <textarea class="form-control" rows="2" name="obs" placeholder="Enter ..."></textarea>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <button type="button" class="btn btn-sm btn-outline-primary save ">@lang('Finalizar')</button>
            <button type="button" class="btn btn-sm btn-outline-info save-print">@lang('Finalizar e
                Imprimir')</button>
            <button type="button" class="btn btn-sm btn-outline-success d-none saved">@lang('Finalizado')</button>
            <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                    class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i>@lang('Finalizando')</button>
            <button type="button" class="btn btn-sm btn-outline-danger d-none error">@lang('Erro')</button>
        </div>
    </div>

</form>

@push('js')
<script type="text/javascript">
    var print = false;
$(document).on('click', 'form#finalize-proforma button.save', function (event) {
    print = false;
    finalizeSale()
    event.stopPropagation()
});
$(document).on('click', 'form#finalize-proforma button.save-print', function (event) {
    print = true;
    finalizeSale();
    event.stopPropagation()
});

function finalizeSale() {
    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
    });
    let data = $('form#finalize-proforma').serializeArray();

    $.ajax({
        ...ajaxSettings,
        method: 'PUT',
        url: "{{ URL::signedRoute('api.sales.proforma.update', ['proforma'=> $proforma->id]) }}",
        data: data,
        beforeSend: function () {

            $('form#finalize-proforma button.save').addClass('d-none');
            $('form#finalize-proforma button.saved').addClass('d-none');
            $('form#finalize-proforma button.error').addClass('d-none');
            $('form#finalize-proforma button.saving').removeClass('d-none');
        },
        statusCode: {
            202: function (response) {
                Toast.fire({
                    type: 'success',
                    title: '@lang("Entradas finalizadas").'
                });

                $('form#finalize-proforma button.save').addClass('d-none');
                $('form#finalize-proforma button.saved').removeClass('d-none');
                $('form#finalize-proforma button.saving').addClass('d-none');
                $('form#finalize-proforma button.error').addClass('d-none');


                if (print)
                    goto('{{ URL::signedRoute('web.sales.proforma.print', ['proforma'=> $proforma->id]) }}')
                else{
                    reload()
                }

            },
            403: () => {
                reload();
            },
            401: (response) => {

                Toast.fire({
                    type: 'error',
                    title: '@lang("Volte a fazer o login").'
                })

                $.ajax({
                    url: "{{ URL::signedRoute('web.system.exit') }}",
                    dataType: "HTML",
                    success: function (response) {
                        setTimeout(() => {
                            reload();
                        }, 1500);
                    }
                });
            },
            422: (response) => {
                Toast.fire({
                    type: 'error',
                    title: '@lang("Verifique os dados inseridos e submeta outra vez").'
                })

                $('form#create-proforma-sale button.save').removeClass('d-none');
                $('form#create-proforma-sale button.saved').addClass('d-none');
                $('form#create-proforma-sale button.saving').addClass('d-none');
                $('form#create-proforma-sale button.error').addClass('d-none');
            },
        },
        error: (response) => {
            $('form#finalize-proforma button.save').addClass('d-none');
            $('form#finalize-proforma button.saved').addClass('d-none');
            $('form#finalize-proforma button.saving').addClass('d-none');
            $('form#finalize-proforma button.error').removeClass('d-none');
            setTimeout(() => {
                $('form#finalize-proforma button.save').removeClass('d-none');
                $('form#finalize-proforma button.saved').addClass('d-none');
                $('form#finalize-proforma button.saving').addClass('d-none');
                $('form#finalize-proforma button.error').addClass('d-none');
            }, 2000)
        }
    });
}
</script>
@endpush
